<?php

/*
 画像ファイルのハッシュ値を扱って
 重複排除するモジュール
 img/ thumb/ が対象
*/
require_once 'fsutil.php';

// link()が利用できるか判定
function enable_link(){
  if (PHP_OS == "WIN32" || PHP_OS == "WINNT") {
    return false;
  } else {
    return true;
  }
}

class FileHashDB{
  var $con;
  var $lock;

  //modeには'r'か'w'を指定
  function FileHashDB($dbpath){
    $lockpath =  $dbpath . ".lck";
    $this->lock = fopen($lockpath, "w") or die("can't open sqlite.lck");
    flock($this->lock, LOCK_EX) or die("can't lock sqlite.lck");

    if(!is_file($dbpath)){
      $this->con = new SQLite3($dbpath);
      //db テーブル作成

      $this->con->exec(
        "create table filehash  ".
        " (id integer primary key autoincrement,".
        "  orign text,".
        "  hash text,".
        "  path text) ");
      $this->con->exec(
        "create index hashidx on filehash (hash) ");
      $this->con->exec(
        "create index pathidx on filehash (path) ");
      $this->con->exec(
        "create index orignidx on filehash (orign) ");
    }else{
      $this->con = new SQLite3($dbpath);
    }
    $this->con->exec("pragma synchronous=off;");
    $this->con->exec("pragma journal_mode=memory;");
  }

  function close(){
    $this->con->close();
    flock($this->lock, LOCK_UN);
    fclose($this->lock);
  }

  function optimize()
  {
    $this->con->exec("VACUUM");
  }

  function trans_begin()
  {
    $this->con->exec("BEGIN DEFERRED;");
  }

  function trans_commit()
  {
    $this->con->exec("COMMIT;");
  }

  function remove_entry($path)
  {
    $stmt = $this->con->prepare(
      "delete from filehash ".
      " where path =:path ");
    $stmt->bindValue(":path", $path, SQLITE3_TEXT );
    $stmt->execute();
  }

  function find_entry($path)
  {
    $stmt = $this->con->prepare(
      "select hash from filehash ".
      " where path =:path ");
    $stmt->bindValue(":path", $path, SQLITE3_TEXT );
    $result = $stmt->execute();
    if($arr = $result->fetchArray(SQLITE3_NUM)){
      return $arr[0];
    }else{
      return false;
    }
  }

  function near_orign($orign)
  {
    $stmt = $this->con->prepare(
      "select distinct st2.orign from filehash st1 ".
      "left outer join filehash st2 ".
      "  on st2.hash = st1.hash ".
      "where st1.orign=:orign ");
    $stmt->bindValue(":orign", $orign, SQLITE3_TEXT );
    $result = $stmt->execute();
    $orgs = array();
    while($arr = $result->fetchArray(SQLITE3_NUM)){
      $orgs[] = $arr[0];
    }
    return $orgs;
  }

  function find_same_hash($hash)
  {
    $stmt = $this->con->prepare(
      "select path from filehash ".
      " where hash = :hash ".
      " order by id asc ");
    $stmt->bindValue(":hash", $hash, SQLITE3_TEXT );
    $result = $stmt->execute();
    while($arr = $result->fetchArray(SQLITE3_NUM)){
      $path = $arr[0];
      if(is_file($path)){
        return $path;
      }else{
        $this->remove_entry($path);
      }
    }
    return false;
  }

  function register_entry($path, $orign)
  {
    $entry = $this->find_entry($path);
    if(!$entry){
      $hash = sha1_file($path);
      
      //link file
      if(enable_link()){
        $samefile = $this->find_same_hash($hash);
        if($samefile)
        {
          $tmpname = $path . ".tmp";
          if(link($samefile, $tmpname)){
            unlink($path);
            rename($tmpname, $path);
          }
        }
      }
      //register entry
      $stmt = $this->con->prepare(
        "insert into filehash(orign, path, hash) ".
        " values(:orign,:path,:hash) ");
      $stmt->bindValue(":orign", $orign, SQLITE3_TEXT );
      $stmt->bindValue(":path", $path, SQLITE3_TEXT );
      $stmt->bindValue(":hash", $hash, SQLITE3_TEXT );
      $stmt->execute();
    }
  }
}

/*
 ログのファイルハッシュ一覧を更新
*/
function filehash_update($url)
{
  if(readConfig('USEFILEHASHING')){
    $basenames = urlToBasename($url);
    $dbpath    = readConfig("METADIR") . METAFILEHASH;
    $imgdir    = readConfig("CONTDIR") . $basenames["CONT"] . _PGET_IMG_DIR_;
    $thumbdir  = readConfig("CONTDIR") . $basenames["CONT"] . _PGET_THUMB_DIR_;
    $targetfiles = array_merge( find_files($imgdir), find_files($thumbdir) );
    $db = new FileHashDB($dbpath);
    $db->trans_begin();
    foreach($targetfiles as $target){
      $db->register_entry($target,$url);
    }
    $db->trans_commit();
    $db->close();
  }
}

function filehash_remove($url)
{
  if(readConfig('USEFILEHASHING')){
    $basenames = urlToBasename($url);
    $dbpath    = readConfig("METADIR") . METAFILEHASH;
    $imgdir    = readConfig("CONTDIR") . $basenames["CONT"] . _PGET_IMG_DIR_;
    $thumbdir  = readConfig("CONTDIR") . $basenames["CONT"] . _PGET_THUMB_DIR_;
    $targetfiles = array_merge( find_files($imgdir), find_files($thumbdir) );
    $db = new FileHashDB($dbpath);
    $db->trans_begin();
    foreach($targetfiles as $target){
      $db->remove_entry($target);
    }
    $db->trans_commit();
    $db->close();
  }
}
