<?php

/*
 JSON形式で格納するKVS
 格納するデータ件数は数千件程度を想定
 
// usage
$db = new JsonKVS( jsondir, sortkey [,order=SORT_ASC]);
$db.put("<key>", "<assoc list>");
$db.allKeys();
$db.get("<key>");
$db.close(); //$db.sort();

//ファイルレイアウト
index.json       // ソート済みキー一覧
sortkeys.json    // ソートキー一覧(index.jsonのソート用)
items/<key>.json // 各key毎のjsonファイル
items.lck        // lockfile
*/

class JsonKVS
{
  var $jsonDir;
  var $sortkey;
  var $order;
 
  var $indexes;
  var $sortkeys;
 
  function JsonKVS( $jsondir, $sortkey, $order=SORT_ASC)
  {
    $this->jsonDir = $jsondir;
    $this->sortkey = $sortkey;
    $this->order   = $order;
    
    if(!is_dir($jsondir)){
      mkdir($jsondir);
    }
    
    $itemdir   = $this->_join( $jsondir, "items" );
    $indexfile = $this->_join( $jsondir, "index.json" );
    $sortfile  = $this->_join( $jsondir, "sortkeys.json" );
    if(is_dir($itemdir)&&is_file($indexfile)&&is_file($sortfile)){
      $this->indexes  = json_decode( file_get_contents( $indexfile ) );
      $this->sortkeys = json_decode( file_get_contents( $sortfile ) );
    }else{
      $this->indexes = array();
      $this->sortkeys = array();
      @mkdir( $itemdir );
    }
  }

  function allKeys()
  {
    return $this->indexes;
  }
 
  function put($key, $value)
  {
    $json    = json_encode($value);
    $sortkey = $value[$this->sortkey];
    
    file_put_contents( $this->_join($this->jsonDir."/items/", $key . ".json"), $json );
    $pos = array_search( $key, $this->indexes);
    if($pos !== false){
      $this->sortkeys[$pos] = $sortkey;
    }else{
      $this->indexes[]  = $key;
      $this->sortkeys[] = $sortkey;
    }
  }
 
  function get($key, $default=false)
  {
    $path = $this->_join($this->jsonDir."/items/", $key.".json");
    if(is_file($path)){
      $json = file_get_contents($path);
      return json_decode($json,true);
    }else{
      return $default;
    }
  }
 
  function sort()
  {
    array_multisort( $this->sortkeys, $this->order, $this->indexes );
  }

  function close()
  {
    $this->sort();
    
    file_put_contents( $this->_join( $this->jsonDir, "index.json" ), json_encode($this->indexes));
    file_put_contents( $this->_join( $this->jsonDir, "sortkeys.json" ), json_encode($this->sortkeys));
  }
 
  function _join($dir, $file)
  {
    return $dir . "/" . $file;
  }
}
