<?php

/*
 * 親バケットからスレッド情報を取得するモジュール
 * pget モジュールと同時にrequireして利用する
**/

require_once dirname(__FILE__) . '/../const.php';
require_once 'httprequest.php';

define('USEPULLZIP', 1);

function _pullcont_zip($REMOTEROOT, $GETURL)
{
  $basenames = urlToBasename($GETURL);
  $rootdir    = readConfig("CONTDIR") . $basenames["CONT"];
  
  $REMOTE_ZIP  = $REMOTEROOT . "download.php" 
                   . "?rooturl=" . urlencode($GETURL)
                   . "&type=zip"
                   . "&dlname=" . urlencode($basenames["ZIP"]) ;
  
  //zipの取得
  $zippath = readConfig("ZIPDIR") . $basenames["ZIP"];
  $hostfp = fopen($REMOTE_ZIP,"rb");
  if(!$hostfp){ return false; }
  
  $localfp = fopen($zippath, "wb");
  
  while(!feof($hostfp)) {
    $data = fread($hostfp, 4096);
    fwrite($localfp, $data);
  }
  fclose($hostfp);
  fclose($localfp);
  
  //zipからcontを解凍
  unzip($zippath , readConfig("CONTDIR"), false, false);
  
  //zipファイルを削除
  unlink($zippath);
}

function _pullcont_files($REMOTEROOT, $GETURL, $meta, $localmeta)
{
  $basenames = urlToBasename($GETURL);
  $rootdir    = readConfig("CONTDIR") . $basenames["CONT"];
  
  $updatehtml = ($localmeta && $meta && $localmeta['htmlhash'] != $meta['htmlhash'] );
  
  $REMOTE_FILES = $REMOTEROOT . "json_api.php"
                   . "?action=readurlitemlist"
                   . "&url=" . urlencode($GETURL) ;
  //リモートからの取得データは以下のようになっている
  // [0] -> ファイルパス 
  // [1] -> URL
  if($resp = safe_file_get_contents($REMOTE_FILES)) {
    $remotefiles = json_decode($resp, true);
    //ローカルファイル一覧の取得
    $localfiles = array();
    foreach( find_files($rootdir) as $path) {
      $localfiles[] = str_replace($rootdir . "/","", $path);
    }
    
    $queryIndex = !readConfig("REBUILDLOG");
    
    //差分計算
    $targets = array();
    foreach($remotefiles as $item) {
      if(!in_array( $item[0], $localfiles) 
      || $updatehtml && ($item[0] == _PGET_INDEX_PAGE_ && $queryIndex)
      || $updatehtml && $item[0] == (_PGET_OTHER_DIR_._PGET_INDEX_PAGE_SRCGZ_)
      || $updatehtml && $item[0] == (_PGET_OTHER_DIR_._PGET_CRAWL_INFO_))
      {
        $targets[] = $item;
      }
    }
    
    //差分ファイルのダウンロード
    foreach($targets as $item) {
      $fullpath = $rootdir . "/" . $item[0];
      mkdir_r(dirname($fullpath));
      
      if($body = safe_file_get_contents( $item[1] )) {
        file_put_contents($fullpath, $body);
      }
    }
    
    //スレッドで削除済みの画像をキャッシュから消す
    //親バケット側でreadConfig("IMGDIR_SYNC")=trueな必要がある
    if( readConfig("IMGDIR_SYNC") ){
      $thImgs = array();
      foreach($remotefiles as $item) {
        if( strpos( $item[0], _PGET_IMG_DIR_) == 0
         || strpos( $item[0], _PGET_THUMB_DIR_) == 0 )
        {
          $thImgs[] = $fullpath = $rootdir . "/" . $item[0];
        }
      }
      $thFiles = array_merge ( 
               find_files($rootdir . "/". preg_replace("/\/$/","",_PGET_IMG_DIR_)),
               find_files($rootdir . "/". preg_replace("/\/$/","",_PGET_THUMB_DIR_) )
               );
      $thDiff = array_diff ($thFiles, $thImgs);
      if( count($thDiff) > 0) {
        log2file(__FILE__.":".__LINE__." IMGDIR_SYNC ".print_r($thDiff,true));
      }
      
      foreach($thDiff as $path){
        unlink($path); //削除
      }
    }
  }
}


/*
 * 親バケットに更新要求を出し
 * zipでスレッドをダウンロードする
 * 更新要求は毎回呼び出し
 * zipでのダウンロードは初回のみ行う
 * zipダウンロードに成功した場合meta情報を返し
 * 初回じゃない場合はfalseを返す
 */
function getFromRemote($REMOTEROOT, $GETURL, $updateHost = true) {
  if($REMOTEROOT == "" ){
    return false;
  }
  
  $REMOTE_UPDATE = $REMOTEROOT . "scrapshot.php"
                   . "?rooturl=" .  urlencode($GETURL);
  
  $REMOTE_META = $REMOTEROOT . "json_api.php"
                   . "?action=readurlinfo"
                   . "&url=" . urlencode($GETURL) ;
  
  if($updateHost) {
    //親バケットの更新要求
    $update = file_get_contents($REMOTE_UPDATE);
  }
  
  $localmeta = readUrlInfo($GETURL);
  $meta = false;
  //ローカルに無い場合のみzipでスレ取得
  if(!$localmeta) {
    //meta情報の取得
    $info = file_get_contents($REMOTE_META);
    $meta = false;
    if($info && $meta = json_decode($info, true)) {
      if(!readConfig("CONTDIRREADONLY")){
        //zipの取得
        if(USEPULLZIP && extension_loaded ("zip")){
          _pullcont_zip($REMOTEROOT, $GETURL);
        }else{
          _pullcont_files($REMOTEROOT, $GETURL, $meta, $localmeta);
        }
      }
      
      //登録者情報の更新
      $meta['user_ip']    = getClientIp();
      $meta['user_host']  = gethostbyaddr($meta['user_ip']);
      $meta['user_regid'] = read_regid();
      
      $tags = array();
      /*//タグを取り込む場合はホスト名を書き換えて削除できるようにする
      foreach($meta['tags'] as $tag){
        $tags[] = array($tag[0], $meta['user_host']);
      }*/
      $meta['tags'] = $tags;
      
      saveInfo($meta);
    }
  }
  return $meta;
}


/*
 * 親バケットからスレッドの差分をダウンロードし
 * メタデータを返す
 * 失敗時はfalse
 */
function getFromRemoteSub($REMOTEROOT, $GETURL) {
  if($REMOTEROOT == "" ){
    return false;
  }
  
  $localmeta  = readUrlInfo($GETURL);
  
  //リモートファイル一覧の取得
  $REMOTE_META = $REMOTEROOT . "json_api.php"
                   . "?action=readurlinfo"
                   . "&url=" . urlencode($GETURL) ;

  $meta = false;
  $resp = safe_file_get_contents($REMOTE_META); //メタデータの取得
  if($resp && $meta = json_decode($resp, true))
  {
    if( !readConfig("CONTDIRREADONLY") )
    {
      if(USEPULLZIP && !$localmeta && extension_loaded ("zip")){
        _pullcont_zip($REMOTEROOT, $GETURL);
      }else{
        _pullcont_files($REMOTEROOT, $GETURL, $meta, $localmeta);
      }
    }
  }else{
    //親バケットにログが無い場合
    //取得依頼を行いログを構築する
    $meta = getFromRemote($REMOTEROOT, $GETURL);
  }
  return $meta;
}

