<?php

require_once dirname(__FILE__) . '/../const.php';

if((version_compare( phpversion(), '5.3' ) < 0)){

if(!defined("_ADD_LOCAL_PEAR_PATH_")) {
 define("_ADD_LOCAL_PEAR_PATH_", true);
 set_include_path(get_include_path() . PATH_SEPARATOR . dirname(__FILE__) . "/pear");
}

require_once 'Request.php';
require_once 'PEAR.php';

function safe_file_get_contents($url, $refUrl=false)
{

  //http オプション
  $option = array(
    "timeout" => "5",
    "allowRedirects" => true,
    "maxRedirects" => 3,
  );

  $req = new HTTP_Request($url, $option);

  if($refUrl) {
    //リファラ追加
    $req->addHeader("Referer",  $refUrl);
  }
  $req->addheader('Connection','Keep-Alive');
  $req->addheader('Keep-Alive',10);

  $res = $req->sendRequest(); //HTTPリクエストの実行

  if (PEAR::isError($res)){
    log2file(__FILE__.":".__LINE__." response error ".$res->getMessage());
  }else{
    $resCode = $req->getResponseCode();
    $length  = $req->getResponseHeader("Content-Length");
    $encode  = $req->getResponseHeader("content-encoding");
    $body    = $req->getResponseBody();

    if( $resCode >= 200 && $resCode < 300
    && ($length == false || $encode != false || strlen( $body ) == $length ) )
    {
      return $body;
    }
  }

  return FALSE;
}

}else{ //phpversion

if(!defined("_ADD_LOCAL_PEAR_PATH_")) {
 define("_ADD_LOCAL_PEAR_PATH_", true);
 set_include_path(get_include_path() . PATH_SEPARATOR . dirname(__FILE__) . "/pear2");
}

require_once("HTTP/Request2.php");

function safe_file_get_contents($url, $refUrl=false)
{
  //http オプション
  $option = array(
    "timeout" => "5",
    "follow_redirects" => true,
    "max_redirects" => 3,
  );

  try{

    $req = new HTTP_Request2($url,  HTTP_Request2::METHOD_GET, $option);

    if($refUrl) {
      //リファラ追加
      $req->setHeader("Referer",  $refUrl);
    }
    $req->setHeader('Connection','Keep-Alive');
    $req->setHeader('Keep-Alive',10);

    $res = $req->send(); //HTTPリクエストの実行

    $resCode = $res->getStatus();
    $length  = $res->getHeader("Content-Length");
    $encode  = $res->getHeader("content-encoding");
    $body    = $res->getBody();

    if( $resCode >= 200 && $resCode < 300
    && ($length == false || $encode != false || strlen( $body ) == $length ) )
    {
      return $body;
    }
  }catch(HTTP_Request2_Exception $e){
    log2file(__FILE__.":".__LINE__." HTTP_Request2_Exception: ". $e->getMessage());
  }
  return FALSE;
}

/*
// file_get_contentsをそのまま利用するパターン
function parseHeaders( $headers )
{
  $head = array();
  foreach( $headers as $k=>$v )
  {
    $t = explode( ':', $v, 2 );
    if( isset( $t[1] ) )
      $head[ strtolower( trim($t[0]) ) ] = trim( $t[1] );
    else
    {
      $head[] = $v;
      if( preg_match( "#HTTP/[0-9\.]+\s+([0-9]+)#",$v, $out ) )
        $head['reponse_code'] = intval($out[1]);
    }
  }
  return $head;
}

function safe_file_get_contents($url, $refUrl=false)
{
  $httpopt = array(
    'method' => 'GET',
    'max_redirects' => '3',
    'timeout' => 3
  );
  if($refUrl){
    $httpopt['header'] = 'Referer: '.$refUrl."\r\n";
  }

  $ctx    = stream_context_create(array('http' => $httpopt));
  $body   = @file_get_contents($url,false,$ctx);
  $header = parseHeaders($http_response_header);

  if( !isset( $header['content-length'] ) ||
      isset( $header['content-encoding'] ) ||
      strlen($body) == $header['content-length'] )
  {
    return $body;
  }

  return FALSE;
}
//*/


} // phpversion


/*
//非同期で指定urlを触る
function async_url_touch($url){
  if(preg_match('/^(.+?):\/\/(\d+\.\d+\.\d+\.\d+|.+?):?(\d+)?(\/.*)?$/', $url, $matches)){

    $protocol = $matches[1];
    $host = $matches[2];
    $port = $matches[3];
    $path = $matches[4];

    if($port == ''){
      $port = '80';
    }

    if($path == ''){
      $path = '/';
    }

    //接続
    $fp = fsockopen($host, $port, $errno, $errstr, 5);
    if (!$fp) {
      return false;
    } else {
      //リクエストを送信
      $out = "GET $path HTTP/1.0\r\n";
      $out .= "Host: $host\r\n";
      $out .= "Connection: Close\r\n\r\n";
      fwrite($fp, $out);
      //すぐに閉じる
      fclose($fp);
    }
    return true;
  }else{
    return false;
  }
}
*/
