<?php

require_once (dirname(__FILE__) . '/../config.php');
require_once 'crawl/pget.php';
require_once 'archive/pzip.php';
require_once 'meta_dao.php';
require_once 'crawl/pullthread.php';
require_once 'dba/textfinder.php';


//----------------------------------
//ダウンロード関連

function getPageInfo( $html ) {
  $result = array(
    "title"     => "",
    "thumb"     => "",
    "res"       => "",
    "res_count" => 1,
    "src1res_day" => "",
    "src1res_time" => "",
  );

  //タイトル取得
  if ( preg_match( "/<title>(.*?)<\/title>/i", $html, $matches) ) {
    $result["title"] = $matches[1];
  }
  //サムネイル取得(1レス目)
  if ( preg_match( '/<img src="(.*?thumb.*?)"/i', $html, $matches) ) {
    $result["thumb"] = $matches[1];
  }else if ( preg_match( '/<img src=\'([^\']*thumb[^\']*)\'/i', $html, $matches) ) {
    $result["thumb"] = $matches[1];
  }
  //本文取得(1レス目)
  if ( preg_match( '/<blockquote>(.*?)<\/blockquote>/i', $html, $matches) ) {
    $result["res"] = $matches[1];
  }
  //レス数カウント
  $result["res_count"] = substr_count($html,"<blockquote");

  //１レス目の日付
  if(preg_match(
     "/([0-9][0-9]\/[0-9][0-9]\/[0-9][0-9])\([^\)]+\)([0-9][0-9]:[0-9][0-9]:[0-9][0-9])/",
     $html,
     $matches) == 1)
  {
    $result["src1res_day"] = $matches[1];
    $result["src1res_time"] = $matches[2];
  }

  return $result;
}

//メタファイル情報の作成
function makeMetaInfo($url, $html)
{
  $basenames = urlToBasename($url);

  $filename = readConfig("CONTDIR") . $basenames["CONT"] . _PGET_INDEX_PAGE_;
  $gzfilename = readConfig("CONTDIR") . $basenames["CONT"] . (_PGET_OTHER_DIR_._PGET_INDEX_PAGE_SRCGZ_);

  //ベースhtmlから基本情報を読み込む
  $pageinfo = getPageInfo($html);

  //サムネイルurlの取得
  $thumb = false;
  if ($pageinfo["thumb"] != "") {

    $thumb = readConfig("CONTURL") . $basenames["CONT"] . $pageinfo["thumb"];
  }

  //ディスク使用容量 計算
  $files = find_files(readConfig("CONTDIR") . $basenames["CONT"]);
  $diskUsage = 0;
  foreach($files as $file) {
    $diskUsage += filesize($file);
  }

  //保有コンテンツ数の計算
  $otherdir  = readConfig("CONTDIR") . $basenames["CONT"] . _PGET_OTHER_DIR_;
  $imgdir    = readConfig("CONTDIR") . $basenames["CONT"] . _PGET_IMG_DIR_;
  $other_files = array();
  $sys_files = array();
  if(is_dir($otherdir)) {
    $other_files = find_files($otherdir);
    $sys_files = array_filter($other_files, 'is_sysfiles');
  }
  $img_files = array();
  if(is_dir($imgdir)) {
    $img_files = find_files($imgdir);
  }

  //保存データの作成
  $info = newInfo();

  $info["date"] = filemtime($filename);
  $info["title"] = $pageinfo["title"];
  $info["url"] = $url ;
  $info["store_url"] = readConfig("CONTURL") . $basenames["CONT"] . _PGET_INDEX_PAGE_ ;
  $info["thumb"] =  $thumb;
  $info["res"] = $pageinfo["res"];
  $info["du"] = $diskUsage;
  $info["res_count"] = $pageinfo["res_count"];
  $info["first_date"] = $info["date"];

  $info["src1res_day"]  = $pageinfo["src1res_day"];
  $info["src1res_time"] = $pageinfo["src1res_time"];
  $info["other_files"]  = count($other_files) + count($img_files) - count($sys_files);
  $info["htmlhash"] = sha1_file($gzfilename);

  //ユーザー情報の設定
  $info['user_ip']    = getClientIp();
  $info['user_host']  = @gethostbyaddr($info['user_ip']);
  $info['user_regid'] = read_regid();

  return $info;
}

function _execDownloadImpl($url, $getImageListFn, $getImageFn)
{
  $basenames = urlToBasename($url);

  //ダウンロードフォルダ作成
  $dldirname = $basenames["CONT"];
  $dldir = readConfig("CONTDIR") . $dldirname;

  if(!file_exists($dldir)){
    mkdir ($dldir);
  }

  //古いmetaファイルを拾う
  $oldInfo = readUrlInfo($url);
  if($oldInfo){
    //ngの場合はそのまま返す
    if($oldInfo["ng"]){
      return $oldInfo;
    }

    //更新無効時間内の場合古いメタファイルを返す
    if($oldInfo["date"] + readConfig("COOLTIME") >= time() ){
      return $oldInfo;
    }
  }

  //親バケットが指定されている場合
  //親バケットと同期して終了する
  if(readConfig("REMOTEROOT") && url_exists(readConfig("REMOTEROOT"))){
    if($remotemeta = getFromRemoteSub( readConfig("REMOTEROOT") , $url))
    {
      //ログ加工をpgetモジュールに依頼する
      cust_pget($url,$dldir,'pgetDmyGetImageList','pgetDmyGetImage',true);
      return mergeInfo($remotemeta, $oldInfo);
    }else if($oldInfo && !url_exists($url) && url_exists("http://www.bing.com/")){
      $oldInfo["lost"] += 1;
    }
    return $oldInfo;
  }

  //ページ取得等を行う
  if($srcHtml = cust_pget($url,$dldir,$getImageListFn,$getImageFn)){
    //make meta info
    $info = makeMetaInfo($url, $srcHtml);
    return mergeInfo($info, $oldInfo);
  }else{
    //metaファイルが存在してばあい
    //前回のクロールは成功していることになるので
    //ロストフラグをたてる
    //内部ネットワークエラーの場合に404にすることを避けるため
    //スクリプトから外部サイトに触れることを確認する

    if($oldInfo && !url_exists($url) && url_exists("http://www.bing.com/")){
      $oldInfo["lost"] += 1;
      return $oldInfo;
    }
    return false;
  }
}


//ダウンロードの実行
function execDownload($url,
                   $getImageListFn = 'pgetDmyGetImageList',
                   $getImageFn = 'pgetDmyGetImage')
{
  $info = _execDownloadImpl($url, $getImageListFn, $getImageFn);
  if($info){
    UpdateSearchIndex($info);//検索indexの更新
  }
  return $info;
}
