<?php

require_once (dirname(__FILE__) . '/../config.php');
require_once 'meta_dao.php';
require_once 'session.php';
require_once 'dba/textfinder.php';
require_once 'const.php';
require_once 'compatible.php';
require_once 'fsutil.php';

//----------------------------------
//ログ関連

function log2file($line) {
  global $ROOTDIR;
  $path = $ROOTDIR . "log.txt";
  $path_lt1 = $ROOTDIR . "log.1.txt";
  
  //ローテート処理 ( 5MB 以上の場合のみ )
  if(is_file($path) && filesize( $path ) > 5000000 ) {
    rename ( $path, $path_lt1 );
  }
  
  //ログ追記
  $fp = @fopen($path, 'a');
  if (!$fp) {
    return false;
  } else {
    if(flock($fp,LOCK_EX)){
      $data = date('c') . $line . "\n";
  
      $bytes = fwrite($fp, $data);
      
      flock($fp,LOCK_UN);
    }
    fclose($fp);
    return $bytes;
  }
}

//----------------------------------
//検索関連

/**
 * andやorに対応した検索を行う
*/
function _andCheck($hoststring, $needle) {
  $needle = preg_replace('/　/', ' ', $needle);
  $needle = preg_replace('/\s+/', ' ', $needle);
  
  $andWords = mb_split("\ ", $needle);

  foreach($andWords as $word) {
    if(strlen($word) > 0 && strpos($hoststring, $word) === FALSE) {
      return FALSE;
    }
  }
  return TRUE;
}

function isContainsWord($hoststring, $needle) {
  //or分割
  $orWords = mb_split("\|", $needle);
  
  foreach($orWords as $orWord) {
    if(_andCheck($hoststring, $orWord)){
      return TRUE;
    }
  }
  return FALSE;
}

//----------------------------------
//サーバー関連

function base64_urlsafe_encode($val) {
 $val = base64_encode($val);
 return str_replace(array('+', '/', '='), array('_', '-', '.'), $val);
}

function base64_urlsafe_decode($val) {
 $val = str_replace(array('_','-', '.'), array('+', '/', '='), $val);
 return base64_decode($val);
}

function get_value($array, $key, $default='') {
  return (is_array($array)&&array_key_exists($key, $array)) ? $array[$key] : $default;
}

function url_exists($url){
  $header = @ftb_get_headers($url);
  if(preg_match('/^HTTP\/.*\s+200\s/i',$header[0])){
    return true;
  }
  return false;
}

function getServer($key, $default = null)
{
    return (isset($_SERVER[$key])) ? $_SERVER[$key] : $default;
}
function getClientIp($checkProxy = true)
{
  if ($checkProxy && getServer('HTTP_CLIENT_IP') != null) {
    $ip = getServer('HTTP_CLIENT_IP');
  } else if ($checkProxy && getServer('HTTP_X_FORWARDED_FOR') != null) {
    $ip = getServer('HTTP_X_FORWARDED_FOR');
  } else {
    $ip = getServer('REMOTE_ADDR');
  }
  return $ip;
}



