<?php

/**
 * ajax向けのjson_api
 * 
**/

/*******************************************************************
パラメータ(post/get)
actionパラメータに機能名の指定に利用し
各機能毎にそれぞれ追加のパラメータを要求する

action:
 readallurl
  param:
   なし
  result:
   保持するスレッドのurl全件のリスト

 readallinfo
  param:
   なし
  result:
   保持するスレッドのmetaデータ全件のリスト

 readurlinfo
  param:
   url 取得元url
  result:
   指定されたurlのmetaデータ
 
 readalltag:
  param:
   term  絞込みキーワード
  result:
   絞込み後のタグ一覧
 
 readtag:
  param:
   url 取得元url
  result:
   スレッドに紐づくタグリスト(utf8)

 setng:
  param:
   url    取得元url
   passwd 管理者パスワードのmd5
  result:
   true

 readurlitemlist:
  param:
   url    取得元url
  result:
   スレッドに紐づく [(相対ファイルパス,公開url)] 情報

 readconfig:
  param:
   なし
  result:
   設定一覧(APPCONST)のjson表現

*******************************************************************/

require_once 'config.php';
require_once 'phplib/common.php';
require_once 'blacklist.php';

require_once 'phplib/session.php';
require_once 'phplib/const.php';

if(readConfig("BAYESIANTAG")){
  require_once 'phplib/analyze/naivebayes_cache.php';
}
//----------------------------------------------------------

function readtag($url) {
  $info = readUrlInfo($url);
  
  return array_map("_tag_value", $info['tags']) ;
}

function overWriteUser($info) {
  $info['user_ip'] = "";
  $info['user_host'] = "";
  $info['user_regid'] = "";
  $xs = array(); ;
  foreach( $info['tags'] as $tag ) {
    //$xs[] = $tag[0];
    $xs[] = array($tag[0],"");
  }
  $info['tags'] = $xs;
  $info['samefiles'] = array();
  return $info;
}

function filtedMeta($meta) {
  $keys = array(
    "date",
    "title",
    "store_url",
    "url",
    "thumb",
    "res",
    "lost",
    "ng",
    "du",
    "res_count",
    "life_time",
    "first_date" ,
    "user_update" ,
    "tags",
    "src1res_day",
    "src1res_time",
    "other_files",
    "htmlhash",
    );
  $newinfo = array();
  foreach($meta as $k => $v) {
    if(in_array($k,$keys)){
      $newinfo[$k] = $v;
    }
  }
  return $newinfo;
}


//----------------------------------------------------------
// データ作成処理

function makeData($ACTION) {
  global $APPCONST;

  $result = FALSE;
  //関数のマッピング
  switch (strtolower($ACTION)) {
  case 'readallurl':
    $xs = readAllInfoCached();
    $ys = array();
    foreach($xs as $x) {
      $ys[] = $x["url"];
    }
    $result = $ys;
    break;
  case 'readallinfo':
    $xs = readAllInfoCached();
    $ys = array();
    foreach($xs as $meta) {
      $nmeta = filtedMeta($meta);
      $meta["life_time"] = getLifetime($meta);
      $nmeta["date_v"] = date("Y/m/d H:i:s", $meta["date"]);
      $nmeta["first_date_v"] = date("Y/m/d H:i:s", $meta["first_date"]);
      
      $nmeta["res_count_v"] = number_format($meta["res_count"]-1);
      $nmeta["du_v"] = number_format(ceil($meta["du"]/1000/100)*0.1,1);
      
      $nmeta["life_time_v"] = floor(max($meta["life_time"],0)/60/60);
      
      $nmeta["firstregister"] =( $meta["user_regid"] == read_regid()
                                && $meta["user_ip"] == getClientIp());
      
      if(readConfig("BAYESIANTAG")){
        $nmeta["bayestag"] = "";
      }
      
      $ys[] = overWriteUser($nmeta);
    }
    
    $result = $ys;
    break;
  case 'readurlinfo':
    $url = get_value($_REQUEST,"url");
    $x   = readUrlInfo($url);
    if($x) {
      $x = filtedMeta($x);
      $x = overWriteUser($x);
    }
    $result = $x;
    break;
  case 'bayestags':
    $urls = get_value($_REQUEST,"urls");
    if(readConfig("BAYESIANTAG")&&$urls) {
      $urls = json_decode( $urls , true );
      $bayes = new NaiveBayesCache(); 
      $result = array();
      foreach($urls as $url) {
        $meta = readUrlInfo($url);
        if($meta){
          $result[$url] = $bayes->classifier( $meta["res"], $meta["url"]);
        }else{
          $result[$url] = '';
        }
      }
      $bayes->close(); 
    }
    break;
  case 'readalltag':
    $term   = get_value($_REQUEST,"term","");
    $result = readalltag();
    if($term != "") {
      $ys = array();
      foreach($result as $word) {
        if(strpos($word, $term) !== FALSE){
          $ys[] = $word;
        }
      }
      $result = $ys;
    }
    break;
  case 'readtag':
    $url    = get_value($_REQUEST,"url");
    $result = readtag($url);
    break;

  case 'setng':
    $url    = get_value($_REQUEST,"url");
    $passwd = get_value($_REQUEST,"passwd");
    if(readConfig("RMPASSWD") == $passwd) {
      $meta = readUrlInfo($url);
      if($meta){
        $meta['ng'] = true;
        saveInfo($meta);
        $result = true;
      }
    }
    break;
  case 'readurlitemlist':
    $url    = get_value($_REQUEST,"url");
    $meta = readUrlInfo($url);
    $basenames = urlToBasename($meta['url']);
    if($meta) {
      $rootdir    = readConfig("CONTDIR") . $basenames["CONT"];
      $rooturldir = readConfig("CONTURL") . $basenames["CONT"];
      $files = array();
      foreach( find_files($rootdir) as $path ) {
        $base = str_replace($rootdir . "/","", $path);
        $files[] = array($base, get_current_uri_dir() . $rooturldir . $base);
      }
      $result = $files;
    }
    break;
  case 'readconfig':
   $config = $APPCONST;
   $config['RMPASSWD'] = '';
   $config['CONTDIR'] = '';
   $config['METADIR'] = '';
   $config['SIO_LOCK'] = '';
   $config['ZIPDIR'] = '';
   $config['LOCKDIR'] = '';
   $config['URLREGX'] = '';
   $config['SESSPATH'] = '';
   $config['SEARCHSVADDR'] = '';
   $config['REMOTEROOT'] = '';
   $result = $config;
   break;
  case 'bookmarklet':
   $result = "javascript:(function(){window.open('" . get_current_uri_dir() . "scrapshot.php?rooturl='+encodeURIComponent(document.URL));})()";
   break;
  }
  return $result;
}

$ACTION = get_value($_REQUEST,"action", false);

//gzip圧縮転送が可能か確認
$headers = getallheaders();
$accenc = get_value($headers, "Accept-Encoding","");
$canGzip = false;
if(strpos($accenc,"gzip") !== FALSE) {
  $canGzip = true;
}

$data = "{}";

if($ACTION){
  $data = json_encode(makeData($ACTION));
}

//-----------------------------------------------------
//出力

header('Content-type: application/json');

if($canGzip){
  header('Content-encoding: gzip');
  $data = gzencode($data);
}

header('Content-Length: ' . strlen($data) );
echo $data;
