<?php

//
// utf-8なテキストを全文検索するモジュール
// sqlite3-ftsを利用する
//
class FulltextFTSDB{

  var $con;
  var $lock;

  function FulltextFTSDB()
  {
    $lockpath = readConfig("LOCKDIR") . "fulltextfts.lock";
    $this->lock = fopen($lockpath, 'w') or die("can't open sqlite.lck");
    flock($this->lock, LOCK_EX) or die("can't lock sqlite.lck");
    $dbpath = readConfig("METADIR") . 'fulltextfts.sqlite';
    if(!is_file($dbpath)) {
      $this->con = new SQLite3($dbpath);
      
      //インデックステーブル
      $this->con->exec(
        "CREATE VIRTUAL TABLE fts_idx USING fts3 (".
        "    key    text PRIMARY KEY,".
        "    words  text);");
    }else{
      $this->con = new SQLite3($dbpath);
    }
    $this->con->exec("pragma synchronous=off;");
    $this->con->exec("pragma journal_mode=memory;");
  }
 
  function close()
  {
    $this->con->close();
    flock($this->lock, LOCK_UN);
    fclose($this->lock);
  }
  
  function optimize()
  {
    $this->con->exec("VACUUM");
  }

//public:
  function Put( $key, $restext)
  {
    $words  = $this->_split_2gram($restext);
    
    $stmt = $this->con->prepare(
       " REPLACE INTO fts_idx ".
       " values(:key,:text) ");
    
    $stmt->bindValue(":key", $key, SQLITE3_TEXT );
    $stmt->bindValue(":text", $words, SQLITE3_TEXT );
    $stmt->execute();
  }
  
  function Search( $text )
  {
    $words = $this->_split_2gram($text," NEAR/2 ");
    
    $stmt = $this->con->prepare(
      " select key from fts_idx ".
      "  where words match :text ");
    $stmt->bindValue(":text", $words, SQLITE3_TEXT );
    
    $result = array();
    $ret = $stmt->execute();
    while($ret && $arr = $ret->fetchArray(SQLITE3_NUM))
    {
      $result[] = $arr[0];
    }
    
    return $result;
  }
 
  function Del($key)
  {
    $stmt = $this->con->prepare(
       " delete from fts_idx ".
       "  where key = :key ");
    $stmt->bindValue(":key", $key, SQLITE3_TEXT );
    $stmt->execute();
  }

  function trans_begin() {
    $this->con->exec("BEGIN DEFERRED;");
  }
  function trans_end() {
    $this->con->exec("END;");
  }
  function trans_commit() {
    $this->con->exec("COMMIT;");
  }
  function trans_rollback() {
    $this->con->exec("ROLLBACK;");
  }
//private:
  function _split_2gram($text, $separate=" ")
  {
    $textarray = preg_split("//u", $text, -1, PREG_SPLIT_NO_EMPTY);
    $result = "";
    $term = count($textarray)-1;
    for($i = 0; $i < $term; $i += 1){
      if($i > 0){
        $result .= $separate;
      }
      $result .= $textarray[$i] . $textarray[$i + 1] ;
    }
    return $result;
  }
};
