<?php

require_once 'config.php';
require_once 'phplib/common.php';
require_once 'phplib/crawl.php';
require_once 'phplib/imgfinder.php';
require_once 'phplib/filehashing.php';
require_once 'phplib/cronlock.php';

//------------------------------------------------

//スレurlから板urlの取得
function getBoardUrl($threadurl)
{
  if(preg_match( '/^(http:\/\/[^\/]+\/[^\/]+\/)/i', $threadurl, $matches)){
    return $matches[1];
  }else{
    return false;
  }
}

//カタログページの参照(古い順)
function getCatalog($baseurl, $sort="2") {
  $urls = array();
  
  $page = $baseurl . "futaba.php?mode=cat&sort=".$sort;
  $html = safe_file_get_contents($page);
  $regex = "/<a href='(res\/[0-9]+\.htm)'.*?src='(http.*s\.jpg)'/i";
  $matches = array();
  if(preg_match_all($regex, $html, $matches, PREG_SET_ORDER)){
    foreach( $matches as $m ) {
      $urls[$baseurl . $m[1]] = array("catalog" => $m[2]);
    }
  }
  
  return $urls;
}

//更新基準URLを特定
function getOldersKey($olds,$url) {
  
  if( strpos( $url, "http://may.2chan.net/b/" ) === 0 
   || strpos( $url, "http://img.2chan.net/b/" ) === 0 )
  {
    $behind = 20;
  }else{
    $behind = 1;
  }
  
  //ksort($olds);
  $old2keys = array_keys($olds) ;
  return $old2keys[ min( count($olds)/2,$behind ) ]; 
}

//板->更新基準urlのキャッシュ
$oldersBook = array();

//キャッシュつき更新基準urlの取得
function getRefOlder($url){
  global $oldersBook;

  $board = getBoardUrl($url);
  if(array_key_exists($board, $oldersBook)){
    return $oldersBook[$board];
  }else{
    $catalog  = getCatalog($board);
    $oldersBook[$board] = getOldersKey($catalog,$url);
    return $oldersBook[$board];
  }
}

function getThreadID($url)
{
  if(preg_match("/\/(\d+).html?/", $url, $m)){
    return intval($m[1], 10);
  }
  return 0;
}

//------------------------------------------------

$locker = new CronLock("cron_get");
if(!$locker->lock()){
  //ロック失敗 -> 前回実行分が動作中のためexit
  return ;
}

//------------------------------------------------
//metaファイル配下を参照し
//古いmetaファイルと関連するファイルを自動で削除する

//read metafile
$metaInfoList = array_reverse(readAllInfo ()) ;

//get
foreach($metaInfoList as $info) {
  
  $refOlder = getRefOlder($info["url"]);
  
  $basenames = urlToBasename($info["url"]);
  
  //img,mayはカタログ古い順の20番目までは毎回更新
  //以外は前回更新から30分以上経過していたら更新
  if($info['lost'] < 2 && ( getThreadID($info["url"]) <= getThreadID($refOlder) || time()-$info["date"] > 30*60 ) ) {
    //内容取得を行う
    $lockpath = readConfig("LOCKDIR") . $basenames["LOCK"];
    //ロック処理(同一スレッドのダウンロードの排他)

    if($lock = fopen($lockpath, 'w')){
      if (flock($lock, LOCK_EX | LOCK_NB)){
        //ロックできた場合はダウンロードを行う。
        if ($info = execDownload($info["url"])) {
          //メタデータのセーブ
          saveInfo($info);

          //画像検索システムに登録
          imgfinder_update($info["url"]);
          //ファイルハッシュを登録
          filehash_update($info["url"]);
        }
        flock($lock, LOCK_UN);
      }
      fclose($lock);
    }
    echo $info["url"] . "<br>\r\n";
  }
}

//キャッシュ更新
removeJsonApiCache();
readAllInfoCached();

$locker->close();
