# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#


import re
from ftg.flow_table import FlowTable
from ftg.flow_priority import FlowPriority
from ftg.flow_entry import FlowEntry
from ftg.formatter.base_formatter import BaseFormatter


class CSVFormatter(BaseFormatter):
    formatter_name = "csv"

# "0-10000","in_port=1,dl_dst=xx:xx:xx:12:50:c8","output=5"

    HEADER_FORMAT = "\"Table-Priority\",\"Match\",\"Instruction\""
    FOOTER_FORMAT = ""

    def format(self):
        formatted_flow = []
        formatted_flow.append(self.get_header())

        for t_no in sorted(self._tables.keys(), key=lambda x: int(x)):
            for p_no in sorted(self._tables[t_no].get_priorities(), key=lambda x: int(x), reverse=True):
                for ent in self._tables[t_no].get_priority(p_no).get_flow_entries():
                    formatted_flow.append(
                        "\"" + t_no + "-" + p_no + "\"," + str(ent))

        formatted_flow.append(self.get_footer())
        return formatted_flow
