/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test.web;

import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.test.Tool;
import com.ftinc.si.assist.test.web.PageAction;
import com.ftinc.si.assist.test.web.ResetBrowser;
import com.ftinc.si.assist.test.web.Snap;
import com.ftinc.si.assist.test.web.SnapshotException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.safari.SafariOptions;

public class PagePlayer {
    private static WebDriver s_driver = null;
    private static MutableCapabilities s_cap = null;
    private static boolean s_is_remote = false;
    protected ArrayList<PageAction> actions = new ArrayList();
    protected boolean snapmode = true;
    protected PageAction cur_action;
    protected boolean result_is_js;
    private ArrayList<String> assert_regs;

    protected String paramName() {
        if (this.actions != null) {
            int i = 0;
            while (i < this.actions.size()) {
                if (this.actions.get(i).getArg("$PARAMETER_NAME") != null) {
                    return this.actions.get(i).getArg("$PARAMETER_NAME").toString();
                }
                ++i;
            }
        }
        return null;
    }

    protected static String getProperty(String key) {
        try {
            return System.getProperty(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static boolean isRemote() {
        return s_is_remote;
    }

    protected boolean isAutomatic() {
        boolean is_auto = true;
        int i = 0;
        while (i < this.actions.size()) {
            PageAction t_act = this.actions.get(i);
            t_act.initAction();
            if (!t_act.isAutomatic()) {
                is_auto = false;
            }
            ++i;
        }
        return is_auto;
    }

    public static void initDriver(HashMap<String, String> browser) throws Exception {
        if (s_driver != null) {
            return;
        }
        String bname = null;
        String server_address = "";
        String user_id = null;
        String pwd = null;
        if (browser != null) {
            bname = browser.get("browser");
            if (bname != null) {
                bname = bname.toLowerCase();
            }
            server_address = browser.get("proxy");
            user_id = browser.get("proxy.user_id");
            pwd = browser.get("proxy.password");
            if (browser.containsKey("class")) {
                s_is_remote = true;
                HashMap t_map = (HashMap)Tool.getObjectfromJSON(HashMap.class, browser.get("capabilities"));
                s_cap = new DesiredCapabilities();
                for (Map.Entry entry : t_map.entrySet()) {
                    s_cap.setCapability((String)entry.getKey(), entry.getValue());
                }
                Class<?> drv_class = Tool.forName(browser.get("class"));
                Class[] arg_classes = new Class[]{URL.class, DesiredCapabilities.class};
                Object[] arg_objs = new Object[]{new URL(browser.get("url")), s_cap};
                s_driver = (WebDriver)Tool.newObject(drv_class, arg_classes, arg_objs);
            }
        } else {
            bname = PagePlayer.getProperty("webtest.browser").toLowerCase();
            if (bname != null) {
                bname = bname.toLowerCase();
            }
            server_address = PagePlayer.getProperty("webtest.proxy");
            user_id = PagePlayer.getProperty("webtest.proxy.user_id");
            pwd = PagePlayer.getProperty("webtest.proxy.password");
            try {
                PagePlayer.setCapWithProxy(bname, server_address, user_id, pwd);
                s_driver = PagePlayer.createDriver();
            }
            catch (Exception e) {
                Tool.alertAndStop(String.valueOf(Messages.getString("PagePlayer.18")) + e.getMessage());
            }
        }
        if (s_driver == null) {
            Tool.alertAndStop(Messages.getString("PagePlayer.19"));
        }
    }

    public ArrayList<String> play(HashMap<String, String> browser) throws Exception {
        try {
            PagePlayer.initDriver(browser);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to initialize browser.");
        }
        if (s_driver == null) {
            throw new IllegalStateException("Failed to initialize browser.");
        }
        if (this.actions.size() == 0) {
            s_driver.quit();
            s_driver = null;
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        this.assert_regs = new ArrayList();
        if (this.actions.size() > 0) {
            PageAction.s_win_id = s_driver.getWindowHandle();
            ArrayList<String> asserts = new ArrayList<String>();
            int i = 0;
            while (i < this.actions.size()) {
                PageAction t_act = this.actions.get(i);
                try {
                    ArrayList<String> t_strlist = this.doAction(t_act, s_driver);
                    if (t_strlist != null && t_act.assertable()) {
                        ArrayList<String> t_reg = t_act.getRegs();
                        asserts.addAll(t_reg);
                        result.addAll(t_strlist);
                    }
                }
                catch (SnapshotException e) {
                    throw e;
                }
                catch (Exception e) {
                    String t_msg = "";
                    if (this.snapmode) {
                        this.takeSnap(s_driver, String.valueOf(t_msg) + "[" + e.getMessage() + "]");
                        if (i < this.actions.size() - 1) {
                            this.recoveryReset(s_driver);
                        }
                    }
                    if (e instanceof NotFoundException) {
                        throw new NotFoundException(Tool.removeRedundancy(null, String.valueOf(t_msg) + "[\n" + Tool.makeIndent(e) + "]"));
                    }
                    throw e;
                }
                ++i;
            }
            if (asserts.size() > 0) {
                this.assert_regs = asserts;
            }
        } else {
            PagePlayer.quit();
        }
        return result;
    }

    public static void quit() {
        if (s_driver != null) {
            s_driver.quit();
            s_driver = null;
        }
    }

    private ArrayList<String> doAction(PageAction act, WebDriver drv) {
        this.cur_action = act;
        return act.doAction(drv);
    }

    private void recoveryReset(WebDriver drv) {
        if (this.actions.get(this.actions.size() - 1) instanceof ResetBrowser) {
            this.actions.get(this.actions.size() - 1).doAction(drv);
        }
    }

    private void takeSnap(WebDriver drv, String msg) {
        if (drv instanceof TakesScreenshot && this.snapmode) {
            Snap t_snap = new Snap(this.cur_action);
            t_snap.arg_map.put("file_header", "error");
            String t_msg = "Action=" + Tool.getJSONfromObject(this.cur_action.arg_map) + "\n error=" + msg;
            List t_list = drv.findElements(By.xpath((String)"//frame|//iframe"));
            if (t_list != null && t_list.size() > 0) {
                int n = t_list.size();
                t_msg = String.valueOf(t_msg) + Messages.getString("PagePlayer.0") + Integer.toString(n);
            }
            t_snap.arg_map.put("message", t_msg);
            try {
                t_snap.doCore(drv, null);
            }
            catch (Exception e) {
                String e_msg = "";
                if (msg != null && msg.length() > 0) {
                    e_msg = e.getMessage();
                }
                throw new SnapshotException("\t\tsnapshot " + e_msg + "[" + msg + "] " + Messages.getString("PagePlayer.35"));
            }
        } else {
            throw new SnapshotException("\t\tsnapshot " + msg + " " + Messages.getString("PagePlayer.35"));
        }
    }

    protected ArrayList<String> getAssertRegs() {
        return this.assert_regs;
    }

    private static void setCapWithProxy(String browser, String svr_address, String user, String pwd) {
        if (user == null) {
            user = "";
        }
        if (pwd == null) {
            pwd = "";
        }
        s_cap = browser.equals("firefox") ? new FirefoxOptions() : (browser.equals("chrome") ? new ChromeOptions() : (browser.equals("safari") ? new SafariOptions() : (browser.equals("ie") ? new InternetExplorerOptions() : (browser.equals("edge") ? new EdgeOptions() : DesiredCapabilities.htmlUnit()))));
        if (svr_address != null && svr_address.length() > 0) {
            Proxy proxy = new Proxy();
            proxy.setProxyType(Proxy.ProxyType.MANUAL);
            if (user.length() > 0) {
                proxy.setHttpProxy(String.valueOf(user) + ":" + pwd + "@" + svr_address);
                proxy.setSslProxy(String.valueOf(user) + ":" + pwd + "@" + svr_address);
                proxy.setSocksProxy(svr_address);
                proxy.setSocksUsername(user);
                proxy.setSocksPassword(pwd);
                Tool.logIfDebug(null, "setHttpProxy=" + user + ":" + pwd + "@" + svr_address);
            } else {
                proxy.setHttpProxy(svr_address);
                proxy.setSocksProxy(svr_address);
                Tool.logIfDebug(null, "setHttpProxy=" + svr_address);
            }
            s_cap.setCapability("proxy", (Object)proxy);
        }
    }

    private static WebDriver createDriver() {
        FirefoxDriver t_drv = null;
        String bname = s_cap.getBrowserName();
        if (bname.equals("firefox")) {
            t_drv = new FirefoxDriver((FirefoxOptions)s_cap);
        } else if (bname.equals("internet explorer")) {
            t_drv = new InternetExplorerDriver((InternetExplorerOptions)s_cap);
        } else if (bname.equals("edge")) {
            t_drv = new EdgeDriver((EdgeOptions)s_cap);
        } else if (bname.equals("chrome")) {
            t_drv = new ChromeDriver((ChromeOptions)s_cap);
        } else if (bname.equals("safari")) {
            t_drv = new SafariDriver((SafariOptions)s_cap);
        }
        return t_drv;
    }
}

