/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.swing;

import java.awt.Component;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import javax.swing.BoundedRangeModel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.sourceforge.freegantt.swing.Application;
import jp.sourceforge.freegantt.swing.TaskLineDataPane;
import jp.sourceforge.freegantt.swing.TaskLineHeaderPane;
import jp.sourceforge.freegantt.swing.TaskLinePane;
import jp.sourceforge.freegantt.util.CalendarUtil;

public class TaskLineRootPane
extends JScrollPane {
    private static final long serialVersionUID = -8965586189659056103L;
    Application app;
    TaskLineHeaderPane headerPane;
    TaskLineDataPane taskLineDataPane;
    TaskLinePane taskLinePane;
    JViewport dataViewport;
    boolean viewportOffsetInitialized = false;

    public TaskLineRootPane(Application app) {
        super(21, 32);
        this.app = app;
        this.taskLinePane = new TaskLinePane(app);
        this.setViewportView(this.taskLinePane);
        this.taskLinePane.setLayout(null);
        this.headerPane = new TaskLineHeaderPane(app, this.taskLinePane);
        this.headerPane.setBounds(0, 0, this.taskLinePane.getWidth(), this.taskLinePane.getHeaderHeight());
        this.taskLinePane.add((Component)this.headerPane, "Center");
        this.taskLineDataPane = new TaskLineDataPane(app, app.getProject(), this.taskLinePane);
        this.taskLineDataPane.setBounds(0, 0, 1, 1);
        this.dataViewport = new JViewport();
        this.dataViewport.setBounds(0, 0, 1, 1);
        this.dataViewport.setView(this.taskLineDataPane);
        this.taskLinePane.add((Component)this.dataViewport, "Center");
        this.getHorizontalScrollBar().getModel().addChangeListener(new ScrollChangeListener());
    }

    public void initializeViewportOffset() {
        Calendar firstDate = this.app.getProject().getFirstDate();
        if (firstDate == null) {
            firstDate = CalendarUtil.toDateCalendar(Calendar.getInstance());
        }
        firstDate.add(5, -1);
        this.setViewportAtCalendar(firstDate);
        this.viewportOffsetInitialized = true;
    }

    public void setViewportAtCalendar(Calendar calendar) {
        int offsetDate = CalendarUtil.subDate(calendar, this.taskLinePane.getChartFromDate());
        int x = offsetDate * this.app.getProject().getCellSize().width;
        int cellWidth = this.app.getProject().getCellSize().width;
        x = Math.max(cellWidth, x);
        x = Math.min(this.getViewport().getView().getWidth() - this.getViewport().getWidth() - cellWidth, x);
        this.getViewport().setViewPosition(new Point(x, 0));
    }

    public Calendar getViewingCalendar() {
        int offset = this.getViewport().getViewPosition().x;
        Calendar calendar = (Calendar)this.taskLinePane.getChartFromDate().clone();
        calendar.add(5, offset / this.app.getProject().getCellSize().width);
        return calendar;
    }

    public void updateChartRange() {
        this.taskLinePane.updateChartRange();
        this.taskLinePane.updateSize();
        this.headerPane.updateWidth();
        this.taskLineDataPane.updateWidth();
        this.repaint();
    }

    public void addPreviousChartRange() {
        Calendar viewing = this.getViewingCalendar();
        this.taskLinePane.setChartToDate((Calendar)this.taskLinePane.getChartFromDate().clone());
        this.taskLinePane.getChartFromDate().add(2, -1);
        this.taskLinePane.updateChartRange();
        this.taskLinePane.updateSize();
        this.headerPane.updateWidth();
        this.taskLineDataPane.updateWidth();
        this.setViewportAtCalendar(viewing);
        this.repaint();
    }

    public void addPostChartRange() {
        Calendar viewing = this.getViewingCalendar();
        this.taskLinePane.setChartFromDate((Calendar)this.taskLinePane.getChartToDate().clone());
        this.taskLinePane.getChartToDate().add(2, 1);
        this.taskLinePane.updateChartRange();
        this.taskLinePane.updateSize();
        this.headerPane.updateWidth();
        this.taskLineDataPane.updateWidth();
        this.setViewportAtCalendar(viewing);
        this.repaint();
    }

    public TaskLinePane getTaskLinePane() {
        return this.taskLinePane;
    }

    public JViewport getDataViewport() {
        return this.dataViewport;
    }

    public TaskLineDataPane getTaskLineDataPane() {
        return this.taskLineDataPane;
    }

    public TaskLineHeaderPane getTaskLineHeaderPane() {
        return this.headerPane;
    }

    @Override
    public void doLayout() {
        System.out.println("TaskLineRootPane doLayout: ");
        super.doLayout();
        this.dataViewport.setBounds(0, this.taskLinePane.getHeaderHeight(), this.taskLinePane.getWidth(), this.taskLinePane.getHeight() - this.taskLinePane.getHeaderHeight());
    }

    public class ScrollChangeListener
    implements PropertyChangeListener,
    ChangeListener {
        @Override
        public void stateChanged(ChangeEvent e) {
            if (!(e.getSource() instanceof BoundedRangeModel)) {
                return;
            }
            BoundedRangeModel model = (BoundedRangeModel)e.getSource();
            if (model.getValueIsAdjusting()) {
                return;
            }
            if (!TaskLineRootPane.this.viewportOffsetInitialized) {
                return;
            }
            if (model.getValue() <= 0) {
                System.out.println("autoViewportAdjust <-");
                System.out.println("autoViewportAdjust value: " + model.getValue());
                System.out.println("autoViewportAdjust min: " + model.getMinimum());
                System.out.println("autoViewportAdjust max: " + model.getMaximum());
                TaskLineRootPane.this.addPreviousChartRange();
            } else if (model.getValue() >= model.getMaximum() - model.getExtent()) {
                System.out.println("autoViewportAdjust ->");
                System.out.println("autoViewportAdjust value: " + model.getValue());
                System.out.println("autoViewportAdjust min: " + model.getMinimum());
                System.out.println("autoViewportAdjust max: " + model.getMaximum());
                TaskLineRootPane.this.addPostChartRange();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
        }
    }
}

