/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.swing;

import java.awt.Container;
import java.util.Calendar;
import javax.swing.JPanel;
import javax.swing.JViewport;
import jp.sourceforge.freegantt.swing.Application;
import jp.sourceforge.freegantt.util.CalendarUtil;

public class TaskLinePane
extends JPanel {
    private static final long serialVersionUID = 843023457646014650L;
    Application app;
    Calendar chartFromDate;
    Calendar chartToDate;

    public TaskLinePane(Application app) {
        this.app = app;
        this.chartFromDate = (Calendar)app.getProject().getChartRangeFromDate().clone();
        this.chartToDate = (Calendar)app.getProject().getChartRangeToDate().clone();
        this.updateChartRange();
        this.updateSize();
    }

    public void updateChartRange() {
        Container viewport;
        Calendar fromDate = (Calendar)this.chartFromDate.clone();
        Calendar toDate = (Calendar)this.chartToDate.clone();
        Calendar projectFromDate = (Calendar)this.app.getProject().getChartRangeFromDate().clone();
        Calendar projectToDate = (Calendar)this.app.getProject().getChartRangeToDate().clone();
        projectFromDate.add(2, -1);
        projectToDate.add(2, 1);
        if (fromDate.getTimeInMillis() > projectFromDate.getTimeInMillis()) {
            fromDate = projectFromDate;
        }
        if (toDate.getTimeInMillis() < projectToDate.getTimeInMillis()) {
            toDate = projectToDate;
        }
        if ((viewport = this.getParent()) != null && viewport instanceof JViewport) {
            Calendar widthCoveredToDate = (Calendar)this.app.getProject().getChartRangeFromDate().clone();
            int viewportWidth = ((JViewport)viewport).getWidth();
            System.out.println(viewportWidth);
            widthCoveredToDate.add(5, viewportWidth / this.getCellWidth());
            widthCoveredToDate.add(2, 1);
            if (toDate.getTimeInMillis() < widthCoveredToDate.getTimeInMillis()) {
                toDate = widthCoveredToDate;
            }
        }
        this.chartFromDate = fromDate;
        this.chartToDate = toDate;
    }

    public void updateSize() {
        int rowCount = this.app.getProject().getRowCount();
        int width = CalendarUtil.subDate(this.chartToDate, this.chartFromDate) * this.getCellWidth();
        int height = rowCount * this.getCellHeight() + this.getHeaderHeight();
        System.out.println("TaskLinePane updateSize done: " + width + "," + height);
        this.setSize(width, height);
        this.setPreferredSize(this.getSize());
    }

    public int getCellWidth() {
        return this.app.getProject().getCellSize().width;
    }

    public int getCellHeight() {
        return this.app.getProject().getCellSize().height;
    }

    public int getHeaderHeight() {
        return this.getCellHeight() * 2;
    }

    public Calendar getChartFromDate() {
        return this.chartFromDate;
    }

    public void setChartFromDate(Calendar calendar) {
        this.chartFromDate = calendar;
    }

    public Calendar getChartToDate() {
        return this.chartToDate;
    }

    public void setChartToDate(Calendar calendar) {
        this.chartToDate = calendar;
    }

    @Override
    public void doLayout() {
        System.out.println("TaskLinePane doLayout: ");
        super.doLayout();
        this.updateChartRange();
    }
}

