/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.swing;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JSplitPane;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.table.TableColumn;
import jp.sourceforge.freegantt.swing.Application;
import jp.sourceforge.freegantt.swing.TaskListTable;

public class GanttChartSplitPane
extends JSplitPane {
    private static final long serialVersionUID = -8567327389185691533L;
    Application app;
    Integer maximumDividerLocation;
    int openedDividerLocation = 0;
    int columnStickWidth = 8;

    public GanttChartSplitPane(Application app, int newOrientation) {
        super(newOrientation);
        this.app = app;
        GanttChartSplitPaneUI ui = new GanttChartSplitPaneUI();
        this.setUI(ui);
        ui.getDivider().addMouseListener(new DividerMouseListener());
        this.addPropertyChangeListener(new DividerLocationChangeListener());
    }

    @Override
    public void setDividerLocation(int location) {
        super.setDividerLocation(location);
        this.app.getProject().getView().setTaskTableWidth(location);
        if (location > 10) {
            this.openedDividerLocation = location;
        }
    }

    public void setMaximumDividerLocation(int location) {
        this.maximumDividerLocation = location;
    }

    @Override
    public int getMaximumDividerLocation() {
        if (this.maximumDividerLocation != null) {
            return this.maximumDividerLocation;
        }
        return super.getMaximumDividerLocation();
    }

    class DividerLocationChangeListener
    implements PropertyChangeListener {
        DividerLocationChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("dividerLocation")) {
                if (GanttChartSplitPane.this.maximumDividerLocation != null && (Integer)evt.getNewValue() > GanttChartSplitPane.this.maximumDividerLocation) {
                    GanttChartSplitPane.this.setDividerLocation(GanttChartSplitPane.this.maximumDividerLocation);
                    return;
                }
                TaskListTable table = GanttChartSplitPane.this.app.getTaskListPane();
                if (table == null) {
                    return;
                }
                ArrayList<TableColumn> columns = Collections.list(table.getColumnModel().getColumns());
                int width = 18;
                for (TableColumn column : columns) {
                    if ((Integer)evt.getNewValue() < (width += column.getWidth()) - GanttChartSplitPane.this.columnStickWidth || (Integer)evt.getNewValue() > width + GanttChartSplitPane.this.columnStickWidth) continue;
                    GanttChartSplitPane.this.setDividerLocation(width);
                }
            }
        }
    }

    class DividerMouseListener
    implements MouseListener {
        DividerMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                GanttChartSplitPane.this.setDividerLocation(GanttChartSplitPane.this.getDividerLocation() < 10 ? GanttChartSplitPane.this.openedDividerLocation : 0);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    class GanttChartSplitPaneUI
    extends BasicSplitPaneUI {
        GanttChartSplitPaneUI() {
        }

        @Override
        public BasicSplitPaneDivider getDivider() {
            return this.divider;
        }
    }
}

