/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.table.TableColumn;
import jp.sourceforge.freegantt.swing.Application;
import jp.sourceforge.freegantt.swing.GanttChartSplitPane;
import jp.sourceforge.freegantt.swing.HeaderChangedListener;
import jp.sourceforge.freegantt.swing.TaskLineRootPane;
import jp.sourceforge.freegantt.swing.TaskListRootPane;

public class GanttChartPane
extends JPanel {
    private static final long serialVersionUID = -968483593747003051L;
    Application app;
    GanttChartSplitPane ganttChartSplitPane;
    TaskLineRootPane taskLineRootPane;
    TaskListRootPane taskListRootPane;

    public GanttChartPane(Application app) {
        super(new BorderLayout());
        this.app = app;
        this.setBackground(Color.blue);
        this.ganttChartSplitPane = new GanttChartSplitPane(app, 1);
        this.ganttChartSplitPane.setBounds(0, 0, 300, 200);
        this.ganttChartSplitPane.setPreferredSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.ganttChartSplitPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.ganttChartSplitPane.setDividerSize(4);
        this.ganttChartSplitPane.setContinuousLayout(true);
        this.add((Component)this.ganttChartSplitPane, "Center");
        this.taskListRootPane = new TaskListRootPane(app);
        this.taskListRootPane.setBounds(0, 0, 100, 200);
        this.ganttChartSplitPane.add(this.taskListRootPane);
        this.taskLineRootPane = new TaskLineRootPane(app);
        this.taskLineRootPane.setBounds(0, 0, 500, 200);
        this.taskLineRootPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ganttChartSplitPane.add(this.taskLineRootPane);
        this.ganttChartSplitPane.setDividerLocation(app.getProject().getView().getTaskTableWidth());
        HeaderChanged headerChanged = new HeaderChanged();
        this.taskListRootPane.getTaskListTable().addHeaderChangedListener(headerChanged);
        this.taskListRootPane.getTaskListTable().fireHeaderChangedEvent();
    }

    public TaskLineRootPane getTaskLineRootPane() {
        return this.taskLineRootPane;
    }

    public TaskListRootPane getTaskListRootPane() {
        return this.taskListRootPane;
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.ganttChartSplitPane.setSize(this.getSize());
    }

    class HeaderChanged
    implements HeaderChangedListener {
        HeaderChanged() {
        }

        @Override
        public void headerChanged(HeaderChangedListener.HeaderChangedEvent e) {
            ArrayList<TableColumn> columns = Collections.list(e.getTable().getColumnModel().getColumns());
            int width = 18;
            System.out.println("GanttChartPane headerChanged ->");
            for (TableColumn column : columns) {
                width += column.getWidth();
            }
            GanttChartPane.this.ganttChartSplitPane.setMaximumDividerLocation(width);
            if (GanttChartPane.this.ganttChartSplitPane.getDividerLocation() > width) {
                GanttChartPane.this.ganttChartSplitPane.setDividerLocation(width);
            }
        }
    }
}

