/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.swing;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Map;

public class CursorState {
    public static final int RESTRICTION_CURSOR = 0x7FFFFFFE;
    public static final int RESTRICTION_CREATE_CURSOR = 0x7FFFFFFD;
    public static final int RESTRICTION_DELETE_CURSOR = 0x7FFFFFFC;
    public static final int COMPLETION_CURSOR = 0x7FFFFFFB;
    Component component = null;
    Cursor currentCursor = null;
    Map<Integer, Cursor> cursors = new HashMap<Integer, Cursor>();

    public CursorState(Component component) {
        this.component = component;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(this.getClass().getResource("restriction.png"));
        Cursor cursor = toolkit.createCustomCursor(image, new Point(15, 15), "restriction");
        this.cursors.put(0x7FFFFFFE, cursor);
        image = toolkit.getImage(this.getClass().getResource("restriction_create.png"));
        cursor = toolkit.createCustomCursor(image, new Point(15, 15), "restriction_create");
        this.cursors.put(0x7FFFFFFD, cursor);
        image = toolkit.getImage(this.getClass().getResource("restriction_delete.png"));
        cursor = toolkit.createCustomCursor(image, new Point(15, 15), "restriction_delete");
        this.cursors.put(0x7FFFFFFC, cursor);
        image = toolkit.getImage(this.getClass().getResource("completion.png"));
        cursor = toolkit.createCustomCursor(image, new Point(15, 15), "completion");
        this.cursors.put(0x7FFFFFFB, cursor);
    }

    public void setCursor(int type) {
        Cursor cursor = this.cursors.get(type);
        if (cursor == null) {
            cursor = this.createCursor(type);
        }
        if (cursor != this.currentCursor) {
            this.component.setCursor(cursor);
            this.currentCursor = cursor;
        }
    }

    public void setDefaultCursor() {
        if (this.currentCursor != null) {
            this.component.setCursor(Cursor.getDefaultCursor());
            this.currentCursor = null;
        }
    }

    private Cursor createCursor(int type) {
        return new Cursor(type);
    }
}

