/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.data;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jp.sourceforge.freegantt.data.Member;
import jp.sourceforge.freegantt.data.Print;
import jp.sourceforge.freegantt.data.Task;
import jp.sourceforge.freegantt.data.View;
import jp.sourceforge.freegantt.swing.HolidayTableModel;
import jp.sourceforge.freegantt.swing.MemberTableModel;
import jp.sourceforge.freegantt.swing.TaskListTableModel;
import jp.sourceforge.freegantt.swing.TaskMemberComboBoxModel;
import jp.sourceforge.freegantt.util.CalendarUtil;

public class Project {
    public static final int CALENDAR_MODE_DATE = 0;
    public static final int CALENDAR_MODE_WEEK = 1;
    String filename;
    String name = "";
    String summary = "";
    List<Member> members = new ArrayList<Member>();
    List<Task> tasks = new ArrayList<Task>();
    List<Integer> fixedHolidays = new ArrayList<Integer>();
    List<Calendar> additionalHolidays = new ArrayList<Calendar>();
    Dimension cellSize = new Dimension(14, 16);
    int calendarMode = 0;
    View view = new View();
    Print print = new Print();
    int maxLevel;
    Calendar chartFromDate;
    Calendar chartToDate;
    private TaskListTableModel taskTableModel;
    private MemberTableModel memberTableModel;
    private HolidayTableModel holidayTableModel;
    private TaskMemberComboBoxModel taskMemberComboBoxModel;

    public void setCalendarMode(int mode) {
        this.calendarMode = mode;
    }

    public int getCalendarMode() {
        return this.calendarMode;
    }

    public boolean isCalendarModeDate() {
        return this.calendarMode == 0;
    }

    public Print getPrint() {
        return this.print;
    }

    public void setPrint(Print print) {
        this.print = print;
    }

    public View getView() {
        return this.view;
    }

    public void setView(View view) {
        this.view = view;
    }

    public Dimension getCellSize() {
        return this.cellSize;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public List<Member> getMembers() {
        return this.members;
    }

    public void setMembers(List<Member> members) {
        this.members = members;
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<Task> tasks) {
        this.tasks = tasks;
    }

    public List<Integer> getFixedHolidays() {
        return this.fixedHolidays;
    }

    public void setFixedHolidays(List<Integer> fixedHolidays) {
        this.fixedHolidays = fixedHolidays;
    }

    public List<Calendar> getAdditionalHolidays() {
        return this.additionalHolidays;
    }

    public void setAdditionalHolidays(List<Calendar> additionalHolidays) {
        this.additionalHolidays = additionalHolidays;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    public TaskListTableModel getTaskTableModel() {
        return this.taskTableModel;
    }

    public MemberTableModel getMemberTableModel() {
        return this.memberTableModel;
    }

    public HolidayTableModel getHolidayTableModel() {
        return this.holidayTableModel;
    }

    public TaskMemberComboBoxModel getTaskMemberComboBoxModel() {
        return this.taskMemberComboBoxModel;
    }

    public Calendar getChartRangeFromDate() {
        return this.chartFromDate;
    }

    public Calendar getChartRangeToDate() {
        return this.chartToDate;
    }

    public Project() {
        this.updateTableModel();
    }

    public void updateTableModel() {
        this.taskTableModel = new TaskListTableModel(this);
        this.memberTableModel = new MemberTableModel(this);
        this.holidayTableModel = new HolidayTableModel(this);
        this.taskMemberComboBoxModel = new TaskMemberComboBoxModel(this);
    }

    public boolean isHoliday(Calendar calendar) {
        int week = calendar.get(7);
        if (this.fixedHolidays.contains(week)) {
            return true;
        }
        return this.additionalHolidays.contains(calendar);
    }

    public boolean isAdditionalHoliday(Calendar calendar) {
        return this.additionalHolidays.contains(calendar);
    }

    public void update() {
        ArrayList<Task> sortedTasks = new ArrayList<Task>(this.tasks);
        Collections.sort(sortedTasks, new Comparator<Task>(){

            @Override
            public int compare(Task lhs, Task rhs) {
                if (lhs.getLevel() == rhs.getLevel()) {
                    return 0;
                }
                return lhs.getLevel() > rhs.getLevel() ? 1 : -1;
            }
        });
        for (Task task : sortedTasks) {
            this.updateChildrenPeriod(task);
            this.updateParentPeriod(task);
        }
        this.maxLevel = 0;
        if (!sortedTasks.isEmpty()) {
            this.maxLevel = ((Task)sortedTasks.get(sortedTasks.size() - 1)).getLevel();
        }
        this.updateCliticalPath();
        this.updateAllVisibility();
    }

    public void updateChildrenPeriod(Task task) {
        if (task.isParent()) {
            return;
        }
        if (task.getStartDate() == null) {
            return;
        }
        if (task.getPeriod() == null) {
            task.setPeriod(0);
        }
        int leftPeriod = task.getPeriod();
        int realPeriod = 0;
        Calendar now = (Calendar)task.getStartDate().clone();
        int i = 0;
        while (i < 365 && (double)leftPeriod > 0.0) {
            if (!this.isHoliday(now)) {
                leftPeriod = (int)((double)leftPeriod - 1.0);
            }
            realPeriod = (int)((double)realPeriod + 1.0);
            now.add(5, 1);
            ++i;
        }
        task.setRealPeriod(realPeriod);
    }

    private List<Task> getChildTasks(Task targetTask) {
        ArrayList<Task> childTasks = new ArrayList<Task>();
        if (targetTask.getLevel() == 0) {
            return childTasks;
        }
        boolean found = false;
        for (Task task : this.tasks) {
            if (targetTask == task) {
                found = true;
                continue;
            }
            if (!found) continue;
            if (task.getLevel() >= targetTask.getLevel()) break;
            childTasks.add(task);
        }
        return childTasks;
    }

    private Task getParentTask(Task targetTask) {
        if (targetTask.getLevel() == this.maxLevel) {
            return null;
        }
        Task parentTask = null;
        for (Task task : this.tasks) {
            if (task == targetTask) break;
            if (task.getLevel() <= targetTask.getLevel()) continue;
            parentTask = task;
        }
        return parentTask;
    }

    public void updateParentPeriod(Task task) {
        if (!task.isParent()) {
            return;
        }
        task.setStartDate(null);
        task.setPeriod(null);
        task.setRealPeriod(null);
        long from = Long.MAX_VALUE;
        long to = Long.MIN_VALUE;
        List<Task> children = this.getChildTasks(task);
        for (Task child : children) {
            if (child.getStartDate() == null) continue;
            long childFrom = child.getStartDate().getTimeInMillis();
            if (childFrom < from) {
                from = childFrom;
            }
            if (childFrom > to) {
                to = childFrom;
            }
            if (child.getRealPeriod() == null) continue;
            long childTo = childFrom + child.getRealPeriod().longValue() * 86400000L;
            if (childTo < from) {
                from = childTo;
            }
            if (childTo <= to) continue;
            to = childTo;
        }
        if (to < from) {
            return;
        }
        Calendar startDate = Calendar.getInstance();
        startDate.setTimeInMillis(from);
        task.setStartDate(startDate);
        task.setPeriod((int)((to - from) / 86400000L));
        task.setRealPeriod((int)((to - from) / 86400000L));
    }

    public List<Task> getVisibleTasks() {
        ArrayList<Task> visibleTasks = new ArrayList<Task>();
        for (Task task : this.tasks) {
            if (!task.isVisible()) continue;
            visibleTasks.add(task);
        }
        return visibleTasks;
    }

    public Task findTaskByIndex(int index) {
        if (index < 0 || this.tasks.size() <= index) {
            return null;
        }
        return this.tasks.get(index);
    }

    public Task findTaskByRow(int row) {
        if (row < 0) {
            return null;
        }
        int index = this.getIndexFromRow(row);
        if (index < 0 || index >= this.tasks.size()) {
            return null;
        }
        return this.findTaskByIndex(index);
    }

    public int getIndexFromRow(int row) {
        if (row < 0) {
            return -1;
        }
        int index = 0;
        int rowCount = -1;
        while (rowCount <= row) {
            Task task = this.findTaskByIndex(index);
            if (task == null || task.isVisible()) {
                ++rowCount;
            }
            if (rowCount == row) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int getRowByTask(Task targetTask) {
        if (targetTask == null) {
            return -1;
        }
        int index = 0;
        int rowCount = -1;
        while (index < this.tasks.size()) {
            Task task = this.findTaskByIndex(index);
            if (task == null || task.isVisible()) {
                ++rowCount;
            }
            if (task == targetTask) {
                return rowCount;
            }
            ++index;
        }
        return -1;
    }

    public int getIndexByTask(Task targetTask) {
        int index = 0;
        while (index < this.tasks.size()) {
            Task task = this.findTaskByIndex(index);
            if (task == targetTask) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public void removeRow(int row) {
        Task targetTask = this.findTaskByRow(row);
        for (Task task : this.tasks) {
            if (targetTask == null) continue;
            task.getRestrictions().remove(targetTask);
        }
        if (targetTask != null) {
            this.tasks.remove(targetTask);
        }
        this.update();
        this.taskTableModel.fireTableChanged();
    }

    public void insertRow(int row) {
        this.tasks.add(this.getIndexFromRow(row), new Task());
        this.update();
        this.taskTableModel.fireTableChanged();
    }

    public Calendar getFirstDate() {
        Calendar firstDate = Calendar.getInstance();
        boolean found = false;
        firstDate.setTimeInMillis(Long.MAX_VALUE);
        for (Task task : this.tasks) {
            if (task.getStartDate() == null || firstDate.getTimeInMillis() <= task.getStartDate().getTimeInMillis()) continue;
            found = true;
            firstDate = (Calendar)task.getStartDate().clone();
        }
        if (!found) {
            return null;
        }
        return firstDate;
    }

    public int getWholePeriod() {
        Calendar firstDate = this.getFirstDate();
        Calendar lastDate = Calendar.getInstance();
        boolean found = false;
        lastDate.setTimeInMillis(Long.MIN_VALUE);
        if (firstDate == null) {
            return 0;
        }
        for (Task task : this.tasks) {
            Calendar endDate = task.getEndDate();
            if (endDate == null || lastDate.getTimeInMillis() >= endDate.getTimeInMillis()) continue;
            found = true;
            lastDate = endDate;
        }
        if (!found) {
            return 0;
        }
        return CalendarUtil.subDate(lastDate, firstDate);
    }

    public int getRowCount() {
        int rowCount = 0;
        int index = 0;
        while (index < this.tasks.size()) {
            Task task = this.findTaskByIndex(index);
            if (task == null || task.isVisible()) {
                ++rowCount;
            }
            ++index;
        }
        return rowCount;
    }

    public void removeMember(int index) {
        if (index >= this.members.size()) {
            return;
        }
        Member member = this.members.get(index);
        for (Task task : this.tasks) {
            if (task.getMember() != member) continue;
            task.setMember(null);
        }
        this.members.remove(index);
        this.getMemberTableModel().fireTableChanged();
        this.getTaskTableModel().fireTableChanged();
    }

    public void removeAdditionalHoliday(int index) {
        if (index >= this.additionalHolidays.size()) {
            return;
        }
        this.additionalHolidays.remove(index);
        this.update();
        this.getHolidayTableModel().fireTableChanged();
        this.getTaskTableModel().fireTableChanged();
    }

    public void updateChartRange() {
        this.chartFromDate = this.getFirstDate();
        if (this.chartFromDate == null) {
            this.chartFromDate = CalendarUtil.toDateCalendar(Calendar.getInstance());
        }
        this.chartToDate = this.getFirstDate();
        int period = this.getWholePeriod();
        if (this.chartToDate != null) {
            this.chartToDate.add(5, period);
        }
        if (this.chartToDate == null) {
            this.chartToDate = CalendarUtil.toDateCalendar(Calendar.getInstance());
        }
    }

    public Task setNewTaskAtRow(int row) {
        int index = this.getIndexFromRow(row);
        while (this.tasks.size() <= index) {
            this.tasks.add(new Task());
        }
        Task task = new Task();
        this.tasks.set(index, task);
        return task;
    }

    public void updateCliticalPath() {
        System.out.println("Project updateCliticalPath: ");
        for (Task task : this.tasks) {
            task.setCliticalPath(false);
        }
        List<Task> endTasks = this.getEndTasks();
        for (Task endTask : endTasks) {
            this.traceCliticalTask(endTask);
        }
    }

    protected List<Task> getEndTasks() {
        Calendar endDate;
        ArrayList<Task> endTasks = new ArrayList<Task>();
        long lastEndTime = 0L;
        for (Task task : this.tasks) {
            long endTime;
            endDate = task.getEndDate();
            if (endDate == null || lastEndTime >= (endTime = endDate.getTimeInMillis())) continue;
            lastEndTime = endTime;
        }
        for (Task task : this.tasks) {
            endDate = task.getEndDate();
            if (endDate == null || endDate.getTimeInMillis() != lastEndTime) continue;
            endTasks.add(task);
        }
        return endTasks;
    }

    protected void traceCliticalTask(Task endTask) {
        System.out.println("Project traceCliticalPath: " + endTask.getName());
        endTask.setCliticalPath(true);
        ArrayList<Task> restrictionTasks = new ArrayList<Task>();
        for (Task task : this.tasks) {
            Calendar endDate;
            if (task == endTask || (endDate = task.getEndDate()) == null || !task.getRestrictions().contains(endTask)) continue;
            System.out.println(CalendarUtil.subDateUsingHoliday(this, endTask.startDate, endDate));
            if (CalendarUtil.subDateUsingHoliday(this, endTask.startDate, endDate) > 0) continue;
            restrictionTasks.add(task);
        }
        for (Task task : restrictionTasks) {
            this.traceCliticalTask(task);
        }
    }

    public void toggleTaskFold(int row) {
        Task task = this.findTaskByRow(row);
        if (task == null) {
            return;
        }
        if (task.isOpened()) {
            task.setOpened(false);
            this.updateChildTasksVisibility(task);
        } else {
            task.setOpened(true);
            this.updateChildTasksVisibility(task);
        }
    }

    public void updateAllVisibility() {
        for (Task task : this.tasks) {
            this.updateTaskVisibility(task);
        }
    }

    private void updateChildTasksVisibility(Task targetTask) {
        List<Task> childTasks = this.getChildTasks(targetTask);
        for (Task child : childTasks) {
            this.updateTaskVisibility(child);
        }
    }

    private void updateTaskVisibility(Task targetTask) {
        Task parent = this.getParentTask(targetTask);
        while (parent != null) {
            if (!parent.isOpened()) {
                targetTask.setVisible(false);
                return;
            }
            parent = this.getParentTask(parent);
        }
        targetTask.setVisible(true);
    }

    public void removeDestRestrictions(Task task) {
        for (Task src : this.getTasks()) {
            src.getRestrictions().remove(task);
        }
        this.update();
    }

    public void removeSrcRestrictions(Task task) {
        task.getRestrictions().clear();
        this.update();
    }
}

