package com.small_it_office.flatserve.guice.internal;

import javax.servlet.ServletConfig;

import com.google.inject.Module;
import com.small_it_office.flatserve.core.ApplicationException;
import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginImplementation;
import com.small_it_office.flatserve.core.request.internal.RequestParameterMapper;
import com.small_it_office.flatserve.core.request.internal.RequestParameterReader;
import com.small_it_office.flatserve.core.response.internal.ResponseSender;
import com.small_it_office.flatserve.core.service.internal.HttpServiceExecutor;
import com.small_it_office.flatserve.core.service.internal.HttpServiceFactory;
import com.small_it_office.flatserve.guice.GuiceConfig;
import com.small_it_office.shared.meslog.message.Message;

/**
 * GuicevOC̎\NXłB
 */
public class GuicePluginImplementation implements PluginImplementation {

	/**
	 * {@inheritDoc}
	 */
	public HttpServiceExecutor getHttpServiceExecutor() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	public HttpServiceFactory getHttpServiceFactory() {
		return new GuiceHttpServiceFactory();
	}

	/**
	 * {@inheritDoc}
	 */
	public RequestParameterReader getRequestParameterReader() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	public RequestParameterMapper getRequestParameterMapper() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	public ResponseSender getResponseSender() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	public void init(Config config, ServletConfig servletConfig) {
		GuiceConfig guiceConfig = config.getOptionalConfig(GuiceConfig.class);
		if (guiceConfig == null) {
			throw new ApplicationException(Message.get("FSGUC-ERR002"));
		}
		for (Module module : guiceConfig.getModules()) {
			if (module == null) {
				throw new ApplicationException(Message.get("FSGUC-ERR003"));
			}
		}
	}

}
