package com.small_it_office.flatserve.aop.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

import org.aopalliance.intercept.MethodInterceptor;

import com.small_it_office.flatserve.core.ApplicationException;
import com.small_it_office.shared.meslog.message.Message;

/**
 * ̃Ame[Vt^ꂽNX̂݃C^[Zv^KpΏۂƂĎw肷AXyNgłB
 * RXgN^Ŏw肳ꂽAme[Vt^ĂȂNX́AC^[Zv^KpΏۂƂ܂B
 */
public class AnnotationAssignedAspect extends Aspect {

	/**
	 * C^[Zv^KpΏۂ̃NXɕt^ׂAme[VB
	 */
	private Class<? extends Annotation> annotation;

	/**
	 * RXgN^B
	 * @param interceptor C^[Zv^
	 * @param annotation C^[Zv^KpΏۂ̃NXɕt^ׂAme[V
	 */
	public AnnotationAssignedAspect(MethodInterceptor interceptor, Class<? extends Annotation> annotation) {
		super(interceptor);
		this.annotation = annotation;
	}

	/**
	 * {@inheritDoc}
	 * Ŏw肳ꂽNXɃRXgN^Ŏw肳ꂽAme[Vt^Ăꍇ̂trueԂ܂B
	 */
	@Override
	public boolean isAssignable(Class<?> serviceClass, Method serviceMethod) {
		Annotation a = serviceClass.getAnnotation(annotation);
		if (a == null) {
			a = serviceMethod.getAnnotation(annotation);
		}
		return a != null;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void validate() {
		super.validate();
		if (annotation == null) {
			throw new ApplicationException(Message.get("FSAOP-ERR006"));
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return "annotation assignable aspect(" + annotation.getName() + ")";
	}

}
