package com.small_it_office.flatserve.guice.internal;

import java.lang.reflect.Method;
import java.util.List;

import javax.servlet.ServletConfig;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginPart;
import com.small_it_office.flatserve.core.service.internal.HttpServiceFactory;
import com.small_it_office.flatserve.guice.GuiceConfig;

/**
 * GuiceɑΉHttpServiceFactory̎NXłB
 * GuiceInjectorgHTTPT[rXNX̃CX^X𐶐܂B
 */
public class GuiceHttpServiceFactory implements HttpServiceFactory {

	/**
	 * ̃vOCi̗D揇ʁB
	 */
	private static final int PLUGIN_PRIORITY = 896;

	/**
	 * GuiceInjectorB
	 */
	private Injector injector;

	/**
	 * {@inheritDoc}
	 */
	public Object create(Class<?> serviceClass, Method method) {
		return injector.getInstance(serviceClass);
	}

	/**
	 * {@inheritDoc}
	 */
	public void init(Config config, ServletConfig servletConfig) {
		List<Module> modules = null;
		GuiceConfig guiceConfig = config.getOptionalConfig(GuiceConfig.class);
		modules = guiceConfig.getModules();
		injector = Guice.createInjector(modules);
	}

	/**
	 * {@inheritDoc}
	 * ̎łfalseԂ܂B
	 */
	public boolean nest() {
		return false;
	}

	/**
	 * {@inheritDoc}
	 */
	public int priority() {
		return PLUGIN_PRIORITY;
	}

	/**
	 * {@inheritDoc}
	 */
	public void setNestedObject(PluginPart o) {
	}

}
