/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.aop.internal;

import com.small_it_office.flatserve.aop.AspectConfig;
import com.small_it_office.flatserve.aop.internal.Aspect;
import com.small_it_office.flatserve.aop.internal.HttpServiceMethodInvocationImpl;
import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.service.HttpServiceException;
import com.small_it_office.flatserve.core.service.internal.HttpServiceExecutor;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import com.small_it_office.shared.meslog.message.Message;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectInvoker {
    private HttpServiceExecutor serviceExecutor;
    private RequestContext context;
    private Iterator<MethodInterceptor> interceptorIterator;
    private HttpServiceMethodInvocationImpl invocation;
    private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

    public AspectInvoker(RequestContext context, Config config, HttpServiceExecutor serviceExecutor, Method method, Object[] params, Object service) {
        this.context = context;
        this.serviceExecutor = serviceExecutor;
        this.invocation = new HttpServiceMethodInvocationImpl(context, config, this, method, params, service);
        AspectConfig aspectConfig = (AspectConfig)config.getOptionalConfig(AspectConfig.class);
        this.interceptorIterator = this.assignInterceptors(aspectConfig, service.getClass());
    }

    private Iterator<MethodInterceptor> assignInterceptors(AspectConfig aspectConfig, Class<?> serviceClass) {
        ArrayList<MethodInterceptor> list = new ArrayList<MethodInterceptor>();
        List<Aspect> aspectList = aspectConfig.getAspectList();
        for (Aspect aspect : aspectList) {
            boolean assignable = aspect.isAssignable(serviceClass);
            if (this.logger.isDebugEnabled()) {
                if (assignable) {
                    this.logger.debug("FSAOP-LOGD001", new Object[]{aspect.toString(), serviceClass.getName(), aspect.getInterceptor().getClass().getName()});
                } else {
                    this.logger.debug("FSAOP-LOGD002", new Object[]{aspect.toString(), serviceClass.getName(), aspect.getInterceptor().getClass().getName()});
                }
            }
            if (!assignable) continue;
            list.add(aspect.getInterceptor());
        }
        return list.iterator();
    }

    public Object invoke() {
        try {
            return this.proceed();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new HttpServiceException(Message.get((String)"FSAOP-ERR002", (Object[])new Object[0]), e);
        }
    }

    public Object proceed() throws Throwable {
        if (this.interceptorIterator.hasNext()) {
            MethodInterceptor next = this.interceptorIterator.next();
            this.logger.info("FSAOP-LOGI001", new Object[]{next.getClass().getName()});
            Object result = next.invoke((MethodInvocation)this.invocation);
            this.logger.info("FSAOP-LOGI002", new Object[]{next.getClass().getName()});
            return result;
        }
        Method method = this.invocation.getMethod();
        Object[] params = this.invocation.getArguments();
        Object service = this.invocation.getThis();
        this.logger.info("FSAOP-LOGI003", new Object[]{service.getClass().getName(), method.getName()});
        this.logger.debug("FSAOP-LOGD003", new Object[]{this.serviceExecutor.getClass().getName()});
        Object result = this.serviceExecutor.execute(this.context, method, params, service);
        this.logger.info("FSAOP-LOGI004", new Object[]{service.getClass().getName(), method.getName()});
        return result;
    }
}

