/*
 * Decompiled with CFR 0.152.
 */
package filebookmark.view;

import filebookmark.actions.DelAction;
import filebookmark.actions.OpenAction;
import filebookmark.model.Bookmark;
import filebookmark.model.Category;
import filebookmark.util.ElementType;
import filebookmark.util.FileBookmarkUtil;
import filebookmark.util.XmlAccessor;
import filebookmark.view.BookmarkTransfer;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;

public class BookmarkView
extends ViewPart {
    private TreeViewer viewer;
    private DrillDownAdapter drillDownAdapter;
    private ViewContentProvider provider;
    private OpenAction openAction;
    private MenuManager menuManager;
    private List dragList;

    public void createPartControl(Composite parent) {
        this.provider = new ViewContentProvider();
        this.viewer = new TreeViewer(parent, 770);
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        this.viewer.setContentProvider((IContentProvider)this.provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setInput((Object)this.getViewSite());
        this.viewer.expandAll();
        this.openAction = new OpenAction();
        this.hookDoubleClickAction();
        this.hookDragAction();
        this.hookDropAction();
        this.hookMouseHoverAction();
        this.hookKeyPressAction();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.menuManager = new MenuManager("#PopupMenu");
        this.menuManager.setRemoveAllWhenShown(true);
        this.menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("additions"));
                manager.add((IContributionItem)new Separator("additions-end"));
            }
        });
        Menu menu = this.menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(this.menuManager, this.getSite().getSelectionProvider());
        this.viewer.expandAll();
    }

    private void hookKeyPressAction() {
        this.viewer.getTree().addListener(2, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 127) {
                    DelAction delAction = new DelAction();
                    delAction.selectionChanged(null, BookmarkView.this.viewer.getSelection());
                    delAction.run(null);
                }
            }
        });
    }

    private void hookMouseHoverAction() {
        this.viewer.getTree().addListener(32, new Listener(){

            public void handleEvent(Event event) {
                TreeItem item = BookmarkView.this.viewer.getTree().getItem(new Point(event.x, event.y));
                if (item != null) {
                    Bookmark obj = (Bookmark)item.getData();
                    if (obj.getType() == ElementType.CATEGORY) {
                        BookmarkView.this.viewer.getTree().setToolTipText("");
                    } else if (obj.getType() == ElementType.BOOKMARK) {
                        BookmarkView.this.viewer.getTree().setToolTipText(obj.getPath());
                    } else {
                        BookmarkView.this.viewer.getTree().setToolTipText("");
                    }
                } else {
                    BookmarkView.this.viewer.getTree().setToolTipText("");
                }
            }
        });
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Bookmark obj = (Bookmark)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (obj.getType() == ElementType.CATEGORY) {
                    if (BookmarkView.this.viewer.getExpandedState((Object)((Category)obj))) {
                        BookmarkView.this.viewer.collapseToLevel((Object)((Category)obj), 1);
                    } else {
                        BookmarkView.this.viewer.expandToLevel((Object)((Category)obj), 1);
                    }
                } else if (obj.getType() == ElementType.BOOKMARK) {
                    BookmarkView.this.openAction.doubleClickRun(event.getSelection());
                }
            }
        });
    }

    private void hookDragAction() {
        Transfer[] transfers = new Transfer[]{BookmarkTransfer.getTransfer()};
        this.viewer.addDragSupport(2, transfers, new DragSourceListener(){

            public void dragFinished(DragSourceEvent event) {
            }

            public void dragSetData(DragSourceEvent event) {
            }

            public void dragStart(DragSourceEvent event) {
                List selection = ((IStructuredSelection)BookmarkView.this.viewer.getSelection()).toList();
                for (Object obj : selection) {
                    if (((Bookmark)obj).getType() == ElementType.CATEGORY && "Bookmark".equals(((Bookmark)obj).getName())) {
                        event.doit = false;
                    }
                    if (obj instanceof Bookmark) continue;
                    event.doit = false;
                }
                BookmarkView.this.dragList = selection;
                event.data = BookmarkView.this.dragList;
            }
        });
    }

    private void hookDropAction() {
        Transfer[] transfers = new Transfer[]{BookmarkTransfer.getTransfer(), org.eclipse.ui.views.navigator.LocalSelectionTransfer.getTransfer()};
        this.viewer.addDropSupport(6, transfers, new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
                block8: {
                    Transfer[] transfer;
                    Bookmark dropObject;
                    block9: {
                        event.detail = 0;
                        if (event.item == null || !(event.item instanceof TreeItem)) break block8;
                        dropObject = (Bookmark)event.item.getData();
                        if (BookmarkView.this.dragList == null) break block9;
                        for (Object obj : BookmarkView.this.dragList) {
                            Bookmark dragObject = (Bookmark)obj;
                            if (dragObject.getType() == ElementType.CATEGORY) {
                                if (dragObject.equals(dropObject)) {
                                    event.detail = 0;
                                    break block8;
                                }
                                if (!this.isDrop(dropObject, ((Category)dragObject).getChildrenList())) {
                                    event.detail = 0;
                                    break block8;
                                }
                                event.detail = 2;
                                continue;
                            }
                            event.detail = 2;
                        }
                        break block8;
                    }
                    if (dropObject.getType() != ElementType.CATEGORY) break block8;
                    DropTarget droptarget = (DropTarget)event.getSource();
                    Transfer[] transferArray = transfer = droptarget.getTransfer();
                    int n = 0;
                    int n2 = transferArray.length;
                    while (n < n2) {
                        ISelection selection;
                        List selectionList;
                        Transfer targetTransfer = transferArray[n];
                        if (targetTransfer instanceof LocalSelectionTransfer && (selectionList = ((IStructuredSelection)(selection = ((LocalSelectionTransfer)targetTransfer).getSelection())).toList()) != null && selectionList.size() > 0) {
                            for (Object obj : selectionList) {
                                if (!(obj instanceof IFile) && !(obj instanceof ICompilationUnit)) {
                                    event.detail = 0;
                                    break;
                                }
                                event.detail = 4;
                            }
                        }
                        ++n;
                    }
                }
            }

            public boolean isDrop(Bookmark dropObject, List<Bookmark> children) {
                if (children.contains(dropObject)) {
                    return false;
                }
                for (Bookmark child : children) {
                    if (child.getType() != ElementType.CATEGORY || !((Category)child).hasChildren() || this.isDrop(dropObject, ((Category)child).getChildrenList())) continue;
                    return false;
                }
                return true;
            }

            public void drop(DropTargetEvent event) {
                if (event.item != null && event.item instanceof TreeItem) {
                    Bookmark dropObject = (Bookmark)event.item.getData();
                    if (dropObject.getType() == ElementType.CATEGORY && BookmarkView.this.dragList != null) {
                        for (Object obj : BookmarkView.this.dragList) {
                            Bookmark dragObject = (Bookmark)obj;
                            List<Bookmark> parentList = dragObject.getParentCategory().getChildrenList();
                            int delIndex = parentList.indexOf(dragObject);
                            ((Category)dropObject).addChild(parentList.remove(delIndex));
                        }
                    } else if (dropObject.getType() == ElementType.BOOKMARK && BookmarkView.this.dragList != null) {
                        for (Object obj : BookmarkView.this.dragList) {
                            Bookmark dragObject = (Bookmark)obj;
                            List<Bookmark> parentList = dragObject.getParentCategory().getChildrenList();
                            int delIndex = parentList.indexOf(dragObject);
                            List<Bookmark> list = dropObject.getParentCategory().getChildrenList();
                            int index = list.indexOf(dropObject);
                            list.add(index, parentList.remove(delIndex));
                            dragObject.setParentCategory(dropObject.getParentCategory());
                        }
                    } else if (dropObject.getType() == ElementType.CATEGORY && BookmarkView.this.dragList == null) {
                        Transfer[] transfer;
                        DropTarget droptarget = (DropTarget)event.getSource();
                        Transfer[] transferArray = transfer = droptarget.getTransfer();
                        int n = 0;
                        int n2 = transferArray.length;
                        while (n < n2) {
                            Transfer targetTransfer = transferArray[n];
                            if (targetTransfer instanceof LocalSelectionTransfer) {
                                ISelection selection = ((LocalSelectionTransfer)targetTransfer).getSelection();
                                List selectionList = ((IStructuredSelection)selection).toList();
                                for (Object obj : selectionList) {
                                    String name = null;
                                    String path = null;
                                    if (obj instanceof IFile) {
                                        name = ((IFile)obj).getName();
                                        path = ((IFile)obj).getFullPath().toString();
                                    } else if (obj instanceof ICompilationUnit) {
                                        name = ((ICompilationUnit)obj).getElementName();
                                        path = ((ICompilationUnit)obj).getPath().toString();
                                    }
                                    ((Category)dropObject).addChild(new Bookmark(name, path));
                                }
                                break;
                            }
                            ++n;
                        }
                    }
                    BookmarkView.this.refresh();
                    XmlAccessor.writeXml();
                    BookmarkView.this.dragList = null;
                }
            }

            public void dropAccept(DropTargetEvent event) {
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void refresh() {
        this.provider.initialize();
        this.viewer.refresh();
    }

    class ViewContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private Category invisibleRoot;

        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (parent.equals(BookmarkView.this.getViewSite())) {
                if (this.invisibleRoot == null) {
                    this.initialize();
                }
                return this.getChildren(this.invisibleRoot);
            }
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            if (child instanceof Bookmark) {
                return ((Bookmark)child).getParentCategory();
            }
            return null;
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof Category) {
                return ((Category)parent).getChildren();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object parent) {
            if (parent instanceof Category) {
                return ((Category)parent).hasChildren();
            }
            return false;
        }

        public void initialize() {
            Category rootCategory = FileBookmarkUtil.getRootCategory();
            this.invisibleRoot = new Category("root");
            this.invisibleRoot.setName("");
            this.invisibleRoot.setPath("");
            this.invisibleRoot.addChild(rootCategory);
        }
    }

    class ViewLabelProvider
    extends LabelProvider {
        ViewLabelProvider() {
        }

        public String getText(Object obj) {
            return obj.toString();
        }

        public Image getImage(Object obj) {
            if (((Bookmark)obj).getType() == ElementType.CATEGORY) {
                return FileBookmarkUtil.getCategoryCloseImg();
            }
            if ("URL".equals(((Bookmark)obj).getFileType())) {
                return FileBookmarkUtil.getURLImg();
            }
            return FileBookmarkUtil.getBookmarkImg();
        }
    }
}

