/*
 * Decompiled with CFR 0.152.
 */
package filebookmark.util;

import filebookmark.Activator;
import filebookmark.model.Category;
import filebookmark.util.XmlAccessor;
import filebookmark.view.BookmarkView;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class FileBookmarkUtil {
    private static Image CATEGORY_CLOSE;
    private static Image BOOKMARK;
    private static Image URL;

    public static void refreshView() {
        IViewReference[] references;
        IWorkbench workbench = Activator.getDefault().getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IViewReference[] iViewReferenceArray = references = page.getViewReferences();
        int n = 0;
        int n2 = iViewReferenceArray.length;
        while (n < n2) {
            IViewReference r = iViewReferenceArray[n];
            if (r.getId().equals("BookmarkView")) {
                BookmarkView view = (BookmarkView)r.getView(false);
                view.refresh();
                break;
            }
            ++n;
        }
    }

    public static Image getCategoryCloseImg() {
        if (CATEGORY_CLOSE == null) {
            ImageDescriptor descriptor = Activator.getImageDescriptor("icons/book_close_w.gif");
            CATEGORY_CLOSE = descriptor.createImage();
        }
        return CATEGORY_CLOSE;
    }

    public static Image getBookmarkImg() {
        if (BOOKMARK == null) {
            ImageDescriptor descriptor = Activator.getImageDescriptor("icons/bookmark_bl_b.gif");
            BOOKMARK = descriptor.createImage();
        }
        return BOOKMARK;
    }

    public static Image getURLImg() {
        if (URL == null) {
            ImageDescriptor descriptor = Activator.getImageDescriptor("icons/bookmark_bl_g.gif");
            URL = descriptor.createImage();
        }
        return URL;
    }

    public static InputDialog getCreateCategoryDialog() {
        InputDialog newDialog = new InputDialog(Display.getDefault().getActiveShell(), "\u65b0\u3057\u3044\u30ab\u30c6\u30b4\u30ea", "\u540d\u524d:", "New Category", new IInputValidator(){

            public String isValid(String newText) {
                if (newText.length() == 0) {
                    return "\u30ab\u30c6\u30b4\u30ea\u540d\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
                }
                if (!FileBookmarkUtil.getRootCategory().exist(newText)) {
                    return "\u30ab\u30c6\u30b4\u30ea\u540d\u304c\u91cd\u8907\u3057\u3066\u3044\u307e\u3059\u3002";
                }
                return null;
            }
        }){

            protected Point getInitialSize() {
                return new Point(270, 160);
            }
        };
        return newDialog;
    }

    public static Category getRootCategory() {
        return XmlAccessor.getRootCategory();
    }
}

