<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.db.s2dao.model.serializer
 */
/**
 * @file S2DaoScaffoldHiddenEntitySerializer.php
 * @brief deserialize Array to Bean.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: ScaffoldHiddenEntitySerializer.php 17 2007-07-19 13:33:15Z ishitoya $
 */

require_once "ficus/beans/serializer/BeanSerializer.php";
require_once "ficus/lang/Assert.php";
require_once "ficus/lang/reflect/ReflectionClass.php";
require_once "ficus/lang/reflect/annotation/ReflectionAnnotationProperty.php";
require_once "ficus/lang/reflect/annotation/ReflectionAnnotationClass.php";

/**
 * @class Ficus_ScaffoldHiddenEntitySerializer
 */
class Ficus_ScaffoldHiddenEntitySerializer
extends Ficus_AbstractScaffoldSerializer{
    /**
     * serialize entity from array
     * @param $entity Ficus_S2DaoEntity target entity
     * @return string serialized data
     */
    public function serialize($entity, $arguments = null){
        $check = false;
        if(isset($arguments[0])){
            $check = true;
        }
        $result = $this->parse($entity, $check, array());
        return implode("", $result);
    }

    /**
     * serialize
     * @param $entity Ficus_S2DaoEntity entity to parse
     * @param $data Array array to parse
     * @return Ficus_S2DaoEntity result entity
     * @throw Ficus_IllegalBeanException illegal entity.
     */
    private function parse($hidden, $check, $result){
        if($hidden->isComposite() && $hidden->isSelect() == false){
            foreach($hidden->parts() as $part){
                $children = $this->parse($part, $check, array());
                $result = array_merge($result, $children);
            }
            return $result;
        }

        $this->smarty()->assign("qname", $hidden->serializeQname());

        if($check && $hidden->isHidden() == false){
            return $result;
        }
        if($hidden->isSelect()){
            $this->smarty()->assign("value", $hidden->value()->id());
        }else{
            $this->smarty()->assign("value", $hidden->value());
        }
        $result[] = $this->smarty()->fetch("form/hidden.tpl");
        return $result;
    }
}
?>
