<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.db.s2dao.model.serializer
 */
/**
 * @file S2DaoListHeaderScaffoldEntitySerializer.php
 * @brief deserialize Array to Bean.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: ListHeaderScaffoldSerializer.php 17 2007-07-19 13:33:15Z ishitoya $
 */

require_once "ficus/beans/serializer/BeanSerializer.php";
require_once "ficus/lang/Assert.php";
require_once "ficus/lang/reflect/ReflectionClass.php";
require_once "ficus/lang/reflect/annotation/ReflectionAnnotationProperty.php";
require_once "ficus/lang/reflect/annotation/ReflectionAnnotationClass.php";

/**
 * @class Ficus_ListHeaderScaffoldSerializer
 */
class Ficus_ListHeaderScaffoldSerializer
extends Ficus_AbstractScaffoldSerializer{
    /**
     * serialize entity from array
     * @param $entity Ficus_S2DaoEntity target entity
     * @return string serialized data
     */
    public function serialize($scaffold, $arguments = null){
        return $this->parse($scaffold);
    }

    /**
     * serialize
     * @param $entity Ficus_S2DaoEntity entity to parse
     * @param $data Array array to parse
     * @return Ficus_S2DaoEntity result entity
     * @throw Ficus_IllegalBeanException illegal entity.
     */
    private function parse($scaffold){
        $headers = $this->parseScaffold($scaffold);
        $matrix = $this->getHeaderMatrix($headers);
        $this->smarty()->assign("wholeMatrix", $matrix);

        $headers = $this->createHeader($headers);
        $this->smarty()->assign("headers", $headers);
        $this->smarty()->assign("matrix", $matrix);
        return $this->smarty()->fetch("list/headerWithMenu.tpl");
    }

    /**
     * create html header
     */
    protected function createHeader($headers, $lines = array(), $line = 0){
        if(isset($lines[$line]) == false){
            $lines[$line] = "";
        }
        
        foreach($headers as $header){
            if($header->isEmptyChildren() == false){
                $lines =
                    $this->createHeader($header->children(), $lines,
                                        $line + 1);
            }
            $this->smarty()->assign("header", $header);
            $this->smarty()->assign("line", $line);
            $lines[$line] .= $this->smarty()->fetch("list/headerItem.tpl");
        }
        return $lines;
    }

    /**
     * sort
     * @param $scaffold Ficus_Scaffold to sort
     * @return array of entities
     */
    protected function parseScaffold($scaffold, $depth = 0){
        $prototype =
            new Ficus_ConcreteBean(array("depth" => 0,
                                         "children" => array(),
                                         "label" => "",
                                         "matrix" => null));
        $entities = array();
        $labels = array();
        foreach($scaffold as $entity){
            if($entity->isHidden() == false ||
               $entity->isTransitionParent() ){
                $bean = $prototype->createClone();
                $bean->setDepth($depth);
                if($entity->isComposite() && $entity->isSelect() == false){
                    $children =
                        $this->parseScaffold($entity, $depth + 1);
                    $bean->setChildren($children);
                    $bean->setLabel($entity->label());
                    $bean->setMatrix($this->getHeaderMatrix($children));
                    $entities[] = $bean;
                }else{
                    $bean->setLabel($entity->label());
                    $labels[] = $bean;
                }
            }
        }

        $headers = array_merge($labels, $entities);
        return $headers;
    }

    /**
     * get header matrix
     */
    protected function getHeaderMatrix($headers){
        $height = 1;
        $width = 0;
        foreach($headers as $header){
            if($header instanceof Ficus_ConcreteBean &&
               $header->isEmptyChildren() == false){
                $matrix = $this->getHeaderMatrix($header->children());
                if($height == 1){
                    $height += $matrix->height();
                }
                $width += $matrix->width();
            }
            $width++;
        }
        return new Ficus_ConcreteBean(array("height" => $height,
                                            "width"  => $width));
    }
}
?>
