<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.db.s2dao.model.serializer
 */
/**
 * @file S2DaoFormScaffoldSerilizer.php
 * @brief deserialize Array to Bean.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: FormScaffoldSerilizer.php 17 2007-07-19 13:33:15Z ishitoya $
 */

require_once "ficus/beans/serializer/BeanSerializer.php";
require_once "ficus/lang/Assert.php";
require_once "ficus/lang/reflect/ReflectionClass.php";
require_once "ficus/lang/reflect/annotation/ReflectionAnnotationProperty.php";
require_once "ficus/lang/reflect/annotation/ReflectionAnnotationClass.php";

/**
 * @class Ficus_FormScaffoldSerilizer
 */
class Ficus_FormScaffoldSerializer
extends Ficus_AbstractScaffoldSerializer{
    /**
     * serialize entity from array
     * @param $entity Ficus_S2DaoEntity target entity
     * @return string serialized data
     */
    public function serialize($scaffold, $arguments = null){
        return $this->parse($scaffold);
    }

    /**
     * serialize
     * @param $entity Ficus_S2DaoEntity entity to parse
     * @param $data Array array to parse
     * @return Ficus_S2DaoEntity result entity
     * @throw Ficus_IllegalBeanException illegal entity.
     */
    protected function parse($scaffold){
        $entities = $this->parseEntity($scaffold);

        $matrix = $this->getHeaderMatrix($entities, true);
        $this->smarty()->assign("wholeMatrix", $matrix);

        $inputs = $this->createTable($entities);
        $this->smarty()->assign("inputs", $inputs->rows());
        $table = $this->smarty()->fetch("form/table.tpl");
        $table .= $scaffold->serialize("HiddenScaffold");
        $table .= $scaffold->serialize("AssistScaffold");
        return $table;
    }

    /**
     * create table
     */
    protected function createTable($entities){
        $results = new Ficus_ConcreteBean(array("rows" => array()));

        foreach($entities as $index => $entity){
            $children = null;

            if($entity->first() &&
               $entity->isNotFirstChild()){
                $first = $this->createFirstRow($entity, true);
                $results->addRows("<tr>$first</tr>");
            }
            if($entity->isEmptyChildren() == false){
                $entities = $entity->children();
                $children = $this->createTable($entities);

                $this->smarty()->assign("arbitrary", false);
            }

            if($entity->isNotFirst() &&
               $entity->isNotFirstChild()){
                $this->smarty()->assign("entity", $entity);
                $results->addRows($this->smarty()->fetch("form/row.tpl"));
            }
            if(is_null($children) == false){
                $results->addAllRows($children->rows());
            }
        }
        return $results;
    }

    protected function createFirstRow($parent, $root = false){
        if($root){
            $entity = $parent;
        }else{
            if($parent->hasChildren(0) == false){
                return;
            }
            $entity = $parent->children(0);
        }

        $result = "";
        $children = "";
        if($entity->entity()->isArbitrary()){
            $this->smarty()->assign("entity", $entity);
            $this->smarty()->assign("arbitrary",
                                    $entity->entity()->serializeQname());
            if($entity->entity()->isBlank()){
                $this->smarty()->assign("checked", true);
            }
            $entity->disableFirst();
            $result = $this->smarty()->fetch("form/arbitrary.tpl");
        }
        if($entity->isEmptyChildren() == false){
            $children .= $this->createFirstRow($entity);
        }


        $entity->enableFirstChild();
        $this->smarty()->assign("entity", $entity);
        $first = $this->smarty()->fetch("form/first.tpl");
        if($entity->entity()->isArbitrary()){
            return "$result</tr><tr class=\"" . $entity->entity()->serializeQname() . "\" >$first$children";
        }else{ 
            return "$first$children";
        }
    }

    /**
     * parse entity
     */
    protected function parseEntity($scaffold, $depth = 0){
        $prototype =
            new Ficus_ConcreteBean(array("depth" => 0,
                                         "children" => array(),
                                         "label" => "",
                                         "matrix" => null,
                                         "input" => "",
                                         "entity" => "",
                                         "first" => false,
                                         "firstChild" => false));
        $entities = array();
        $results = array();
        foreach($scaffold as $entity){
            if($entity->isHidden() == false ||
               ($entity->isTransitionParent() &&
                $entity->isContextView() == false)){
                $bean = $prototype->createClone();
                $bean->setDepth($depth);
                $bean->setEntity($entity);
                if($entity->isComposite() && $entity->isSelect() == false){
                    $bean->enableFirst();
                }
                if($entity->isComposite() && $entity->isSelect() == false){
                    $children = $this->parseEntity($entity, $depth + 1);
                    $bean->setChildren($children);
                    $bean->setLabel($entity->label());
                    $bean->setMatrix($this->getHeaderMatrix($bean));
                    $entities[] = $bean;
                }else{
                    $bean->setLabel($entity->label());
                    $bean->setInput($entity->serialize());
                    $results[] = $bean;
                }
            }
        }
        return array_merge($results, $entities);
    }

    /**
     * get header matrix
     */
    protected function getHeaderMatrix($parent, $root = false){
        $height = 0;
        $width = 1;
        if($root){
            $headers = $parent;
        }else{
            $headers = $parent->children();
        }
        foreach($headers as $header){
            if($header instanceof Ficus_ConcreteBean &&
               $header->isEmptyChildren() == false){
                $matrix =
                    $this->getHeaderMatrix($header);
                if($width == 1){
                    $width += $matrix->width();
                }
                $height += $matrix->height();
                if($header->entity()->isArbitrary()){
                    $height++;
                }
            }else{
                $height++;
            }
        }
        return new Ficus_ConcreteBean(array("height" => $height,
                                            "width"  => $width));
    }
}
?>
