<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages.scaffold
 */
/**
 * @file FormScaffoldForeperson.php
 * @brief new scaffold foreperson
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: FormScaffoldForeperson.php 19 2007-07-25 18:20:09Z ishitoya $
 */

require_once("ficus/config/Registry.php");

/**
 * @class Ficus_FormScaffoldForeperson
 */
abstract class Ficus_FormScaffoldForeperson
extends Ficus_AbstractScaffoldForeperson{
    protected $id = null;
    /**
     * get context
     */
    abstract protected function getContext();

    /**
     * on submit
     */
    abstract protected function onSubmit();

    /**
     * set id
     */
    public function setId($id){
        $this->id = $id;
    }
    
    /**
     * get entity
     */
    public function entity(){
        return $this->mediator->entity();
    }
    
    /**
     * edit
     * @param $args array of arguments
     */ 
    public function doDefault(){
        if(is_null($this->id)){
            $entity = $this->entity();
        }else{
            $entity =
                $this->mediator->daoManager()->getSingleEntity($this->id);
        }
        return $this->buildForm($entity);
    }

    /**
     * new 
     * @param $args array of arguments
     */
    public function doChildren(){
        return $this->buildForm($this->entity());
    }

    /**
     * new 
     * @param $args array of arguments
     */
    public function doConfirm(){
        $entity = $this->mediator->entity();
        $scaffold = $this->mediator->getScaffold($entity, self::ACTION_VIEW);
        
        $this->mediator->scaffold()->setDo(self::DO_SUBMIT);
        $this->mediator->setEntity($entity);
        $html = $scaffold->serialize("ViewScaffold");
        $html .= $scaffold->serialize("HiddenAllScaffold");

        return $html;
    }

    /**
     * new 
     * @param $args array of arguments
     */
    public function doSubmit(){
        $entity = $this->onSubmit();
        $this->mediator->setEntity($entity);

        return "";
    }

    /**
     * buildNew
     */
    protected function buildForm($entity){
        $transition = null;
        if($this->mediator->request()->has(self::KEY_TRANSITION)){
            $transition = $this->mediator->request()->extractAsString(
                                                         self::KEY_TRANSITION);
            $this->mediator->table()->setCurrentTransition($transition);
        }

        $scaffold =
            $this->mediator->getScaffold($entity, $this->getContext());

        $transition = $this->mediator->table()->getNextTransition($transition);
        if($transition == false){
            $this->mediator->scaffold()->setDo(self::DO_CONFIRM);
            $this->mediator->scaffold()->setTransition("");
        }else{
            $this->mediator->scaffold()->setDo(self::DO_CHILDREN);
            $this->mediator->scaffold()->setTransition($transition);
        }
        $this->mediator->setEntity($entity);

        return $scaffold->serialize("FormScaffold");
    }
}    
?>
