<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages.scaffold
 */
/**
 * @file DeleteScaffoldForeperson.php
 * @brief table manager page
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: DeleteScaffoldForeperson.php 48 2007-09-20 07:21:07Z ishitoya $
 */

require_once("ficus/pages/AbstractPage.php");
require_once("ficus/config/Registry.php");

/**
 * @class Ficus_DeleteScaffoldForeperson
 */
class Ficus_DeleteScaffoldForeperson extends Ficus_AbstractScaffoldForeperson{
    /**
     * delete
     */
    public function doDefault(){
        $ids = $this->mediator->request()->extractAsInt(self::KEY_IDS);
        $entities = $this->mediator->daoManager()->getEntities($ids);
        $scaffold =
            $this->mediator->getScaffold($entities, self::ACTION_VIEW);

        $this->mediator->smarty()->assign(self::KEY_IDS, $ids);
        $this->mediator->scaffold()->setDo(self::DO_SUBMIT);
        return $scaffold->serialize("ListScaffold");
    }
    
    /**
     * delete submit
     */
    public function doSubmit(){
        $ids = $this->mediator->request()->extractAsInt(self::KEY_IDS);

        $dao = $this->mediator->daoManager()->dao();
        $pdo = $this->mediator->daoManager()->pdo();
        $entity = $dao->entity();
        foreach($ids as $id){
            $pdo->query("DELETE FROM histories WHERE person_id = $id");
            $entity->setId($id);
            $dao->delete($entity);
        }

        $this->mediator->smarty()->assign(self::KEY_IDS, $ids);
        return "";
    }
}    
?>
