<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages.listener
 */
/**
 * @file AbstractPageActionListener.php
 * @brief abstract action listener
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: AbstractPageActionListener.php 35 2007-08-24 11:15:33Z ishitoya $
 */

/**
 * @class Ficus_AbstractPageActionListener
 */
abstract class Ficus_AbstractPageActionListener
implements Ficus_PageActionListener{
    const CONTEXT_DO = "do";
    const CONTEXT_DONE = "done";

    /**
     * listen onExecute event
     * @param $page Ficus_Page page to observe
     * @param $action string name of action
     * @param $request Ficus_PageRequest page request
     */
    public function onDo($page, $action, $request){
    }

    /**
     * listen onExecute event
     * @param $page Ficus_Page page to observe
     * @param $action string name of action
     * @param $request Ficus_PageRequest page request
     * @param $result mixc page execution result
     */
    public function onDone($page, $action, $request, $result){
    }
}
?>