<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages
 */
/**
 * @file InlinePage.php
 * @brief abstract inline page
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: InlinePage.php 2 2007-07-11 10:37:48Z ishitoya $
 */

require_once("ficus/pages/Page.php");

/**
 * @class Ficus_InlinePage
 */
abstract class Ficus_InlinePage extends Ficus_Page{
    
    const DEFAULT_MODE = "action";

    /**
     * get default mode
     * @return string default mode name
     */
    public function getDefaultMode(){
        return self::DEFAULT_MODE;
    }

    /**
     * on authorization
     */
    protected function onAuthorization(){
        return self::AUTHORIZATION_NOT_REQUIRED;
    }
}
?>
