<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2006 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.net.rmi.photozou
 */
/**
 * @file Photozou.php
 * @brief
 * @author <a href="mailto:hmx_14@xg8.so-net.ne.jp">MORI Hiroki</a>
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: PDODatabase.php 26 2007-08-01 13:56:06Z ishitoya $
 * 
 *
 */

require_once("Services/Photozou.php");

/**
 * @class Ficus_Photozou
 */
class Ficus_Photozou extends Ficus_Bean{
    const REGISTRY_USERNAME = "photozou.username";
    const REGISTRY_PASSWORD = "photozou.password";
    const REGISTRY_CACHE = "photozou.cache";
    protected $api = null;
    protected $cache = null;

    /**
     * construct
     */
    public function __construct(){
        $username = Ficus_Registry::search(self::REGISTRY_USERNAME);
        if($username == false){
            throw new Ficus_NotReadyException("you must register 'photozou.username' via using Ficus_Registry");
        }
        $password = Ficus_Registry::search(self::REGISTRY_PASSWORD);
        if($password == false){
            throw new Ficus_NotReadyException("you must register 'photozou.password' via using Ficus_Registry");
        }
        $this->api = new Services_Photozou($username, $password);
        $this->cache = Ficus_Registry::search(self::REGISTRY_CACHE);
    }

    

    /**
     * search with keywords
     * @param $keywords array or string keyword
     */
    public function searchPhotosOnlyReUsable($keywords, $limit = 5){
        if(is_int($limit) == false || $limit > 30){
            $limit = 5;
        }
        if(is_array($keywords)){
            $keywords = impoload(" ", $keywords);
        }
        $photos = array();
        $cachefile = null;
        if($this->cache !== false){
            $time = floor(time() / 864000);
            $cachefile = $this->cache . "/" . md5($keywords . $time . $limit);
            $cachefile = Ficus_Dir::normalize($cachefile);
            if(is_readable($cachefile)){
                $cache = file_get_contents($cachefile);
                $photos = unserialize($cache);
            } 
        }

        if(empty($photos)){
            $results =
                $this->api->search_public(array('type' => 'photo',
                                                'limit' => $limit,
                                                'keyword' => $keywords));
            $photos = $results;
            if($this->cache !== false){
                file_put_contents($cachefile, serialize($photos));
            }
        }

        $aggregator = new Ficus_ConcreteBeanAggregator("photos");
        foreach($photos as $result){
            $photo = new Ficus_PhotozouPhoto($result);
            $aggregator->addPhotos($photo);
        }
        return $aggregator;
    }
}
?>