<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2006 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.net.rmi.flickr
 */
/**
 * @file Flickr.php
 * @brief
 * @author <a href="mailto:hmx_14@xg8.so-net.ne.jp">MORI Hiroki</a>
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: PDODatabase.php 26 2007-08-01 13:56:06Z ishitoya $
 * 
 *
 */

require_once("Rasmus/flickr_api.php");

/**
 * @class Ficus_Flickr
 */
class Ficus_Flickr extends Ficus_Bean{
    const APIKEY = "api_key";
    const APISECRET = "api_secret";
    const REGISTRY_APIKEY = "flickr.apikey";
    const REGISTRY_APISECRET = "flickr.apisecret";
    const REGISTRY_CACHE = "flickr.cache";
    protected $api = null;
    protected $cache = null;

    /**
     * construct
     */
    public function __construct(){
        $apikey = Ficus_Registry::search(self::REGISTRY_APIKEY);
        if($apikey == false){
            throw new Ficus_NotReadyException("you must register 'flickr.apikey' via using Ficus_Registry");
        }
        $apisecret = Ficus_Registry::search(self::REGISTRY_APISECRET);
        if($apisecret == false){
            throw new Ficus_NotReadyException("you must register 'flickr.apisecret' via using Ficus_Registry");
        }
        $config = array(self::APIKEY => $apikey,
                        self::APISECRET => $apisecret);
        $this->api = new Flickr($config);
        $this->cache = Ficus_Registry::search(self::REGISTRY_CACHE);
    }

    

    /**
     * search with keywords
     * @param $keywords array or string keyword
     */
    public function searchPhotosOnlyReUsable($keywords, $limit = 5){
        if(is_int($limit) == false || $limit > 30){
            $limit = 5;
        }
        if(is_array($keywords)){
            $keywords = impoload(" ", $keywords);
        }
        $photos = array();
        $cachefile = null;
        if($this->cache !== false){
            $time = floor(time() / 864000);
            $cachefile = $this->cache . "/" . md5($keywords . $time . $limit);
            $cachefile = Ficus_Dir::normalize($cachefile);
            if(is_readable($cachefile)){
                $cache = file_get_contents($cachefile);
                $photos = unserialize($cache);
            } 
        }

        if(empty($photos)){
            $results = $this->api->photosSearch('','','',$keywords,'',
                                                '','','', '4,5,6',
                                                'owner_name,date_taken',$limit,
                                                '','');
            if(isset($results["photos"])){
                $photos = $results["photos"];
                if($this->cache !== false){
                    file_put_contents($cachefile, serialize($photos));
                }
            }
        }

        $aggregator = new Ficus_ConcreteBeanAggregator("photos");
        foreach($photos as $result){
            $photo = new Ficus_FlickrPhoto($result);
            $photo->setUri($this->api->getPhotoURL($result,"m"));
            $aggregator->addPhotos($photo);
        }
        return $aggregator;
    }
}
?>