<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.net.blog
 */
/**
 * @file BlogMetaWeblogAPI.php
 * @brief metaweblog blog api class
 * @author <a href="mailto:mzp@nagoya-u.jp">MIZUNO Hiroki</a>
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: AbstractScaffoldForeperson.php 19 2007-07-25 18:20:09Z ishitoya $
 */

require_once('ficus/net/blog/BlogBloggerAPI.php');

/**
 * blog post via metaWeblogAPI
 *
 * @class Ficus_BlogMetaWeblogAPI
 */
class Ficus_BlogMetaWeblogAPI extends Ficus_BlogBloggerAPI {
    const METAWEBLOG_NEW = "metaWeblog.newPost";
    const METAWEBLOG_EDIT = "metaWeblog.editPost";
    const METAWEBLOG_GETENTRY = "metaWeblog.getPost";
    
    /**
     * get entry
     *
     * @param $entry Ficus_BlogEntry entry
     * @return Ficus_BlogEntry information
     */
    public function getEntry(Ficus_BlogEntry $entry){
        $result = $this->send(self::METAWEBLOG_GETENTRY,
                              array($this->string($entry->id()),
                                    $this->string($this->auth->username()),
                                    $this->string($this->auth->password())));
        $entry->setDescription($result["description"]);
        $entry->setLink($result['link']);
        $entry->setPermaLink($result['permaLink']);
        return $entry;
    }

    /**
     * post entry
     *
     * $content['title'] as a title,
     * and $content['description'] will be treated as content
     * 
     * @param string target Blog
     * @param hash of content
     * @return Ficus_BlogEntry posted entry
     */
    public function post(Ficus_BlogEntry $entry){
        $value = $entry->serialize(
                       new Ficus_BlogMetaWeblogXMLRPCValueEntrySerializer());
        $id = $this->send(self::METAWEBLOG_NEW,
                          array($this->string($this->target),
                                $this->string($this->auth->username()),
                                $this->string($this->auth->password()),
                                $value,
                                $this->bool($entry->publish())));

        return $entry->setId($id);
    }
    
    /**
     * edit entry
     * $content['title'] as a title,
     * and $content['description'] will be treated as content
     *
     * @param Ficus_BlogEntry target entry
     * @param hash content
     * @return boolean true if succeeded
     */
    public function edit(Ficus_BlogEntry $entry){
        $value = $entry->serialize(
                       new Ficus_BlogMetaWeblogXMLRPCValueEntrySerializer());
        return $this->send(self::METAWEBLOG_EDIT,
                           array($this->string($entry->id()),
                                 $this->string($this->auth->username()),
                                 $this->string($this->auth->password()),
                                 $value,
                                 $this->bool($entry->publish())));
    }
}
?>