<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages
 */
/**
 * @file BlogComponentFactory.php
 * @brief Blog component factory
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: BlogComponentFactory.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * Blog component factory
 */

require_once("ficus/io/File.php");
require_once("ficus/config/Registry.php");

/**
 * @class Ficus_BlogComponentFactory
 */
class Ficus_BlogComponentFactory extends Ficus_S2ContainerComponentFactory
implements Ficus_BlogConstants{
    /**
     * dicon file name registry key
     */
    const REGISTRY_DICON_FILENAME = "blog.dicon";

    /**
     * dicon namespace registry key
     */
    const REGISTRY_DICON_NAMESPACE = "blog.namespace";
    
    /**
     * Default dicon file name.
     */
    const DEFAULT_DICON_FILENAME = 'blog.dicon';

    /**
     * dicon namespace.
     */
    const DEFAULT_DICON_NAMESPACE = 'blog.scheme';
    
    /**
     * get Dicon file name from registry
     * @return string dicon filename
     */
    protected function getDiconFileNameRegistry(){
        return self::REGISTRY_DICON_FILENAME;
    }

    /**
     * get Dicon namespace from registry
     * @return string dicon namespace
     */
    protected function getDiconNameSpaceRegistry(){
        return self::REGISTRY_DICON_NAMESPACE;
    }

    /**
     * get dicon file name
     * @return string dicon file name
     */
    protected function getDefaultDiconFileName(){
        return Ficus_File::currentDir()
            ->resolve(self::DEFAULT_DICON_FILENAME)->getPath();
    }
    
    /**
     * get defoult dicon namespace
     * @return string dicon namespace
     */
    protected function getDefaultDiconNameSpace(){
        return self::DEFAULT_DICON_NAMESPACE;
    }

    /**
     * get component
     * @param $name string name of component
     * @param $class string class name
     * @return Ficus_BlogComponentFactory
     */
    public static function getComponent($name, $class = __CLASS__){
        return parent::getComponent($name, $class);
    }

    /**
     * get blog api
     * @param $name string name of component
     * @param $username string name of user
     * @param $password string password
     * @return Ficus_BlogAPI blog api component
     */
    public static function getBlogAPI($name, $username, $password){
        $api = self::getComponent(strtolower($name));
        $api->auth()->setUsername($username)->setPassword($password);
        $api->prepare();
        return $api;
    }
}
?>
