<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.net.blog
 */
/**
 * @file BlogAuth.php
 * @brief blog entry class
 * @author <a href="mailto:mzp@nagoya-u.jp">MIZUNO Hiroki</a>
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: AbstractScaffoldForeperson.php 19 2007-07-25 18:20:09Z ishitoya $
 */
/**
 * Cupssulate The unique entry id.
 *
 * Generally Id will treated as a string.
 *
 * @Class Ficus_BlogAuth
 */
class Ficus_BlogAuth extends Ficus_Bean implements Ficus_BlogConstants{
    /**
     * @var $username string unique ID
     */
    protected $username = null;

    /**
     * @var $password string title
     */
    protected $password = null;

    /**
     * @var $appkey string application key
     */
    protected $appkey = "";

    /**
     * @var $type string type of authentication
     */
    protected $type = self::AUTH_BASIC;

    /**
     * setter
     */
    public function setType($type){
        $this->type = $type;
    }
}
?>