<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.net.blog
 */
/**
 * @file AbstractBlogAPI.php
 * @brief metaweblog blog api class
 * @author <a href="mailto:mzp@nagoya-u.jp">MIZUNO Hiroki</a>
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: AbstractScaffoldForeperson.php 19 2007-07-25 18:20:09Z ishitoya $
 */

require_once('ficus/net/blog/BlogBloggerAPI.php');

/**
 * blog post via metaWeblogAPI
 *
 * @class Ficus_AbstractBlogAPI
 */
abstract class Ficus_AbstractBlogAPI extends Ficus_Bean
implements Ficus_BlogAPI{
    /**
     * @var $endpoint string endpoint of Atom
     */
    protected $client = null;
    
    /**
     * auth object
     */
    protected $auth = null;

    /**
     * endpoint
     */
    protected $endpoint = null;

    /**
     * target blog
     */
    protected $target = null;

    /**
     * setter
     */
    public function setAuth($auth){
        $this->auth = $auth;
    }

    /**
     * setter
     */
    public function setEndpoint($endpoint){
        $this->endpoint = $endpoint;
    }

    /**
     * constructor
     */
    protected function __construct($endpoint){
        $this->endpoint = $endpoint;
        $this->client = $this->createClient($endpoint);
    }

    /**
     * prepare
     */
    public function prepare(){
        //do nothing
        return $this;
    }
    
    /**
     * get submitted entry
     *
     * @return array of entry
     */
    public function getEntries(){
        throw new Ficus_NotSupportedException("get entries is not supported on this API");
    }

    /**
     * get entry
     *
     * @param $entry Ficus_BlogEntry entry
     * @return Ficus_BlogEntry information
     */
    public function getEntry(Ficus_BlogEntry $entry){
        throw new Ficus_NotSupportedException("get entry is not supported on this API");
    }

    /**
     * publish category, 
     *
     * @param Blog_Entry target entry
     * @return bool true if succeeded
     */
    public function createCategory(){
        throw new Ficus_NotSupportedException("create category is not supported on this API");
    }
    
    /**
     * get list of category
     *
     * fetched data structure is like
     * array('categaryName'=>'xx','categoryId'=>'xxx')
     *
     * @return array of category hash
     */
    public function getCategoryList(){
        throw new Ficus_NotSupportedException("get category list is not supported on this API");
    }
    
    /**
     * set a category to the entry
     *
     * @param Blog_Entry target entry
     * @param hash category array('id'=>'<categoryId>','primary'=>true)
     * @return bool true if succeeded
     */
    public function assignCategory($entry, $category, $asPrimary = true){
        throw new Ficus_NotSupportedException("set category is not supported on this API");
    }

    /**
     * create client
     */
    protected function createClient($endpoint){
        throw new Ficus_NotImplementedException("client class must implement createClient method to instanciate client");
    }
}
?>