<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.lang
 */
/**
 * @file Range.php
 * @brief Range for php
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: Range.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * Util Range.
 */
require_once('ficus/lang/Assert.php');
require_once('ficus/lang/RangeIterator.php');
/**
 * @class Ficus_Range
 */
class Ficus_Range implements IteratorAggregate
{
    /**
     * Constructor.
     *
     * @param $first int first value.
     * @param $last int last value.
     */
    public function __construct($first, $last = null) {
        Ficus_Assert::isPrimitiveType($first, 'int');
        Ficus_Assert::isPrimitiveTypeAllowNull($last, 'int');
        if ($first > $last) {
            throw new Ficus_IllegalArgumentException("first value larger than last. {$first, $last}");
        }
        $this->first = $first;
        $this->last = isset($last) ? $last : $first;
    }

    /**
     * Contains.
     *
     * @param $value int value.
     * @return boolean if contains between first and last.
     */
    public function contains($value) {
        Ficus_Assert::isPrimitiveType($value, 'int');
        return ($this->first <= $value && $value <= $this->last);
    }

    /**
     * Get iterator.
     *
     * @return Iterator iterator.
     */
    public function getIterator() {
        return new Ficus_RangeIterator($this->first, $this->last);
    }
}
?>
