<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2006 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.ext.wikipedia
 */
/**
 * @file Wikipedia.php
 * @brief
 * @author <a href="mailto:hmx_14@xg8.so-net.ne.jp">MORI Hiroki</a>
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: PDODatabase.php 26 2007-08-01 13:56:06Z ishitoya $
 * 
 *
 */

require_once("ficus/db/Database.php");
require_once("ficus/exception/SQLException.php");
require_once("ficus/exception/IllegalArgumentException.php");

/**
 * @class Ficus_Wikipedia
 */
class Ficus_Wikipedia{
    const REGISTRY_CACHE = "wikipedia.cache";
    protected $db = null;
    protected $cache = null;

    /**
     * constructor
     */
    public function __construct(Ficus_PDODatabase $db){
        $this->db = $db;
        $this->cache = Ficus_Registry::search(self::REGISTRY_CACHE);
    }
    

    /**
     * searchArticle
     * @param $title string title to search
     * @return article found
     */
    public function search($title, $single = true){
        $results = array();
        $cachefile = null;
        if($this->cache !== false){
            $time = floor(time() / 864000);
            $cachefile = $this->cache . "/" . md5($title . $time);
            $cachefile = Ficus_Dir::normalize($cachefile);
            if(is_readable($cachefile)){
                $cache = file_get_contents($cachefile);
                $results = unserialize($cache);
            }
        }
        if(empty($results)){
            $sql = <<< EOQ
SELECT text.old_text,page.page_title
  FROM page, revision, text
    WHERE page.page_title = '%s'
      AND page.page_id = revision.rev_page
      AND page.page_namespace = 0
      AND revision.rev_text_id = text.old_id
        LIMIT 5
EOQ;
            $results = $this->db->query(sprintf($sql,$title));
            $results = $results->fetchAll();
            /*
            if(empty($results)){
                if($this->hasSimilar($title)){
                    $title = $this->searchSimilar($title);
                    $title = $title["page_title"];
                    $results = $this->db->query(sprintf($sql,$title));
                    $results = $results->fetchAll();
                }
            }
            */
            if(!empty($results)){
                
                $result = $results[0];
                $article = $result["old_text"];
                if($this->isRedirect($result["old_text"])){
                    $title = $this->searchRedirect2($result["old_text"]);
                    $results = $this->db->query(sprintf($sql,$title));
                    $results = $results->fetchAll();
                }
            }
        }

        if(empty($results)){
            //throw new Ficus_PageNotFoundException("Wikipedia page $title is not found");
            return $this->createArticle($title, "記事が見つかりません");
        }

        if($this->cache !== false){
            file_put_contents($cachefile, serialize($results));
        }

        if($single){
            $result = $results[0];
            return $this->createArticle($title, $result["old_text"]);
        }else{
            $articles = array();
            foreach($results as $result){
                $articles[] =
                    $this->createArticle($title, $result["old_text"]);
            }
            return $articles;
        }
    }

    /**
     * create article from an array
     */
    protected function createArticle($title, $text){
        $article = new Ficus_WikipediaArticle();
        return $article->setTitle($title)->setText($text);
    }
    
    /**
     * hasRedirect
     * check title has redirect
     * @param $title string title to search
     * @return boolean true if has redirect
     */
    public function hasRedirect($title){
    	$sql = "SELECT page.page_is_redirect " .
            "FROM page " .
            "WHERE page.page_title = '$title'";
    	$result = $this->db->query($sql);
    	$result = $result->fetch();
        if($result[0] == 0){
        	return false;
        }else{
        	return true;
        }
    }
    /*
    * isRedirect
    * check article text include "#REDIRECT" word
    * @param $text string article to check
    * @return boolean true if include "#REDIRECT" word
    */
    public function isRedirect($article){
        return is_numeric(mb_strpos($article,"#REDIRECT"));
    }
    
    /**
     * hasSimilar
     * check title has redirect
     * @param $title string title to search
     * @return boolean true if has redirect
     */
    public function hasSimilar($title){
    	$sql = "SELECT count(*) " .
            "FROM page " .
            "WHERE page.page_title LIKE '%$title%'";
    	$result = $this->db->query($sql);
        return $result->fetch();
    }
    
    /**
     * searchRedirect
     * @param $title string title to search
     * @return string redirected title
     */
    public function searchRedirect($title){
    	$sql = "SELECT redirect.rd_title " .
            "FROM page,redirect " .
            "WHERE page.page_title = '$title' " .
            "AND page.page_id = redirect.rd_from";
    	return $this->db->query($sql)->fetch();
    }
    /**
    * searchRedirect2
    * search "#REDIRECT" title from text atricle
    * @param $article stirng atrticle to search
    * @return string redirected title
    */
    public function searchRedirect2($article){
        $start = mb_strpos($article,"#REDIRECT [[",0,"UTF-8")+mb_strlen("#REDIRECT [[","UTF-8");
        $end = mb_strpos($article,"]]",0,"UTF-8");
        return mb_substr($article,$start,$end-$start,"UTF-8");
    }
    /**
     * searchSimilar
     * @param $title string title to search
     * @return string redirected title
     */
    public function searchSimilar($title){
    	$sql = "SELECT page_title " .
            "FROM page " .
            "WHERE page.page_title LIKE '%$title%' ";
    	return $this->db->query($sql)->fetch();
    }
    
    
}
?>
