<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.config
 */
/**
 * @file Registry.php
 * @brief Registry for php
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: Registry.php 37 2007-08-28 01:17:50Z ishitoya $
 * 
 * Registry pattern.
 */
/**
 * @class Ficus_Registry
 */
class Ficus_Registry
{
    /**
     * @var registry.
     */
    private static $registry;

    /**
     * @var regist values.
     */
    private $values;

    /**
     * Constructor.
     */
    protected function __construct() {
        $this->values = array();
    }

    /**
     *
     */
    public static function getInstance() {
        if (is_null(self::$registry)) {
            self::$registry = new Ficus_Registry();
        }
        return self::$registry;
    }

    /**
     * Regist value.
     *
     * @param $key string key.
     * @param $value mixed value.
     */
    public static function regist($key, $value) {
        self::getInstance()->values[$key] = $value;
    }

    /**
     * get registry value, alias of search
     *
     * @param $key string registry key.
     * @return mixed value if novalue then throws exception
     */
    public static function get($key){
        return self::search($key);
    }
    
    /**
     * Search registry.
     *
     * @param $key string registry key.
     * @return mixed value if novalue then return false.
     */
    public static function search($key) {
        if (isset(self::getInstance()->values[$key])) {
            return self::getInstance()->values[$key];
        } else if(strpos($key, ".") !== false){
            $keys = explode(".", $key);
            $key = array_shift($keys);
            $values = self::search($key);
            if($values === false){
                return false;
            }
            foreach($keys as $key){
                if(isset($values[$key]) == false){
                    return false;
                }
                $values = $values[$key];
            }
            return $values;
        } else {
            return false;
        }
    }

    /**
     * Remove registry.
     *
     * @param $key string registry key.
     */
    public static function remove($key) {
        $values = self::getInstance()->values;
        if (isset($values[$key])) {
            $values[$key] = null;
            self::getInstance()->values = array_filter($values);
        }
    }
}
?>
