<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.collection
 */
/**
 * @file Collection.php
 * @brief This interface is root of Collections.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: Collection.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 * This interface implementation is ported from Java Collection interface
 * http://java.sun.com/j2se/1.5.0/ja/docs/ja/api/java/ficus/Collection.html
 */

/**
 * @interface Ficus_Collection
 */
interface Ficus_Collection {
    /**
     * add element to Collection
     * @param $element Element to add
     * @return boolean returns true if collection had modified by insertion
     */
    public function add($element);
    
    /**
     * add All elements in parameter
     * @param $elements Array Array of elements to add collection
     * @return boolean returns true if collection had modified by insertion
     */
    public function addAll($elements);

    /**
     * clear all elements in the collection.
     */
    public function clear();

    /**
     * remove element from the collection
     * @param $element element to remove
     * @return boolean returns true if collection had modified by operation
     */
    public function remove($element);

    /**
     * remove element from the collection
     * @param $element element to remove
     * @return boolean returns true if collection had modified by operation
     */
    public function removeAll($element);

    /**
     * get size of the collection 
     * @return integer size of this collection 
     */
    public function size();

    /**
     * to array
     * @return Array array presentation of collection
     */
    public function toArray();

    /**
     * returns true if collection is empty
     * @return boolean true if the collection is empty
     */
    public function isEmpty();
}
