<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2006 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.cli.sa
 */
/**
 * @file SentenceAnalyzerChasenAnalyzeResultBean.php
 * @brief svn add
 * @author <a href="kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: SentenceAnalyzerChasenAnalyzeResultBean.php 24 2007-08-01 08:33:15Z ishitoya $
 *
 * executes analyze result bean for chasen
 */

require_once("ficus/exception/IllegalArgumentException.php");


/**
 * @class Ficus_SentenceAnalyzerChasenAnalyzeResultBean
 */
class Ficus_SentenceAnalyzerChasenAnalyzeResultBean
extends Ficus_SentenceAnalyzerAnalyzeResultBean
{
    public function classToJapanese(){
        return self::$classes[$this->class];
    }

    public function cojugationTypeToJapanese(){
        return self::$conjugationTypes[$this->conjugationType];
    }
    
    protected static $classes =
        array(0 => "BOS/EOS",
              1 => "名詞",
              2 => "名詞-一般",
              3 => "名詞-固有名詞",
              4 => "名詞-固有名詞-一般",
              5 => "名詞-固有名詞-人名",
              6 => "名詞-固有名詞-人名-一般",
              7 => "名詞-固有名詞-人名-姓",
              8 => "名詞-固有名詞-人名-名",
              9 => "名詞-固有名詞-組織",
              10 => "名詞-固有名詞-地域",
              11 => "名詞-固有名詞-地域-一般",
              12 => "名詞-固有名詞-地域-国",
              13 => "名詞-代名詞",
              14 => "名詞-代名詞-一般",
              15 => "名詞-代名詞-縮約",
              16 => "名詞-副詞可能",
              17 => "名詞-サ変接続",
              18 => "名詞-形容動詞語幹",
              19 => "名詞-数",
              20 => "名詞-非自立",
              21 => "名詞-非自立-一般",
              22 => "名詞-非自立-副詞可能",
              23 => "名詞-非自立-助動詞語幹",
              24 => "名詞-非自立-形容動詞語幹",
              25 => "名詞-特殊",
              26 => "名詞-特殊-助動詞語幹",
              27 => "名詞-接尾",
              28 => "名詞-接尾-一般",
              29 => "名詞-接尾-人名",
              30 => "名詞-接尾-地域",
              31 => "名詞-接尾-サ変接続",
              32 => "名詞-接尾-助動詞語幹",
              33 => "名詞-接尾-形容動詞語幹",
              34 => "名詞-接尾-副詞可能",
              35 => "名詞-接尾-助数詞",
              36 => "名詞-接尾-特殊",
              37 => "名詞-接続詞的",
              38 => "名詞-動詞非自立的",
              39 => "名詞-引用文字列",
              40 => "名詞-ナイ形容詞語幹",
              41 => "接頭詞",
              42 => "接頭詞-名詞接続",
              43 => "接頭詞-動詞接続",
              44 => "接頭詞-形容詞接続",
              45 => "接頭詞-数接続",
              46 => "動詞",
              47 => "動詞-自立",
              48 => "動詞-非自立",
              49 => "動詞-接尾",
              50 => "形容詞",
              51 => "形容詞-自立",
              52 => "形容詞-非自立",
              53 => "形容詞-接尾",
              54 => "副詞",
              55 => "副詞-一般",
              56 => "副詞-助詞類接続",
              57 => "連体詞",
              58 => "接続詞",
              59 => "助詞",
              60 => "助詞-格助詞",
              61 => "助詞-格助詞-一般",
              62 => "助詞-格助詞-引用",
              63 => "助詞-格助詞-連語",
              64 => "助詞-接続助詞",
              65 => "助詞-係助詞",
              66 => "助詞-副助詞",
              67 => "助詞-間投助詞",
              68 => "助詞-並立助詞",
              69 => "助詞-終助詞",
              70 => "助詞-副助詞／並立助詞／終助詞",
              71 => "助詞-連体化",
              72 => "助詞-副詞化",
              73 => "助詞-特殊",
              74 => "助動詞",
              75 => "感動詞",
              76 => "記号",
              77 => "記号-一般",
              78 => "記号-句点",
              79 => "記号-読点",
              80 => "記号-空白",
              81 => "記号-アルファベット",
              82 => "記号-括弧開",
              83 => "記号-括弧閉",
              84 => "その他",
              85 => "その他-間投",
              86 => "フィラー",
              87 => "非言語音",
              88 => "語断片");
    protected static $conjugationTypes =
        array(1 => "カ変・クル",
              2 => "カ変・来ル",
              3 => "サ変・スル",
              4 => "サ変・−スル",
              5 => "サ変・−ズル",
              6 => "一段",
              7 => "一段・病メル",
              8 => "五段・カ行イ音便",
              9 => "五段・カ行促音便",
              10 => "五段・カ行促音便ユク",
              11 => "五段・ガ行",
              12 => "五段・サ行",
              13 => "五段・タ行",
              14 => "五段・ナ行",
              15 => "五段・バ行",
              16 => "五段・マ行",
              17 => "五段・ラ行",
              18 => "五段・ラ行アル",
              19 => "五段・ラ行特殊",
              20 => "五段・ワ行ウ音便",
              21 => "五段・ワ行促音便",
              22 => "四段・カ行",
              23 => "四段・ガ行",
              24 => "四段・サ行",
              25 => "四段・タ行",
              26 => "四段・バ行",
              27 => "四段・マ行",
              28 => "四段・ラ行",
              29 => "四段・ハ行",
              30 => "ラ変",
              31 => "上二・ダ行",
              32 => "上二・ハ行",
              33 => "下二・ア行",
              34 => "下二・カ行",
              35 => "下二・ガ行",
              36 => "下二・サ行",
              37 => "下二・ザ行",
              38 => "下二・タ行",
              39 => "下二・ダ行",
              40 => "下二・ナ行",
              41 => "下二・ハ行",
              42 => "下二・バ行",
              43 => "下二・マ行",
              44 => "下二・ヤ行",
              45 => "下二・ラ行",
              46 => "下二・ワ行",
              47 => "下二・得",
              48 => "一段・クレル",
              49 => "一段・ル",
              50 => "形容詞・アウオ段",
              51 => "形容詞・イ段",
              52 => "特殊・ナイ",
              53 => "特殊・タイ",
              54 => "特殊・タ",
              55 => "特殊・ダ",
              56 => "特殊・デス",
              57 => "特殊・ジャ",
              58 => "特殊・マス",
              59 => "特殊・ヌ",
              60 => "文語・ベシ",
              61 => "文語・ゴトシ",
              62 => "文語・ナリ",
              63 => "文語・マジ",
              64 => "文語・シム",
              65 => "文語・キ",
              66 => "文語・ケリ",
              67 => "文語・リ",
              68 => "文語・ル",
              69 => "不変化型",
              70 => "形容詞・イイ",
              71 => "特殊・ドス",
              72 => "一段・得ル",
              73 => "特殊・ヤ");
}
?>
