<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2006 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.cli.ffmpeg
 */
/**
 * @file SentenceAnalyzerChasen.php
 * @brief svn add
 * @author <a href="kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: SentenceAnalyzerChasen.php 24 2007-08-01 08:33:15Z ishitoya $
 *
 * executes ffmpeg abstract class
 */

require_once("ficus/exception/IllegalArgumentException.php");
require_once("ficus/cli/ffmpeg/FFMpeg.php");
require_once("ficus/media/video/VideoBean.php");
require_once("ficus/media/audio/AudioBean.php");


/**
 * @class Ficus_SentenceAnalyzerChasen
 */
class Ficus_SentenceAnalyzerChasen extends Ficus_SentenceAnalyzer
{
    const CACHE = "chasen.cache";
    protected $analyzeResults = array();
    protected $temp = null;
    protected $cache = false;
    protected $cacheFile = null;

    /**
     * consttructor
     */
    public function __construct(){
        $this->cache = Ficus_Registry::search(self::CACHE);
    }

    /**
     * create command
     * @return string ./ffmpeg -f build.xml
     */
    protected function createCommand(){
        if(is_null($this->input)){
            throw new Ficus_IllegalArgumentException("input must be specified before call execute");
        }
            
        $input = $this->normalizeInput($this->input);
        $input = mb_convert_encoding($input, "SJIS", "UTF-8");
        $this->temp = tempnam("", "chasen");
        file_put_contents($this->temp, $input);
        $command = self::CHASEN . " -c " . $this->temp;
        return $command;
    }

    /**
     * public function onExecute
     */
    public function onExecute(){
        $this->cacheFile = null;
        if($this->cache !== false){
            $cache = Ficus_Dir::normalize($this->cache . "/" .
                                          md5($this->input));
            $this->cacheFile = $cache;
            if(file_exists($this->cacheFile)){
                return array();
            }
            return parent::onExecute();
        }else{
            return parent::onExecute();
        }
    }

    /**
     * process result
     * @return boolean true if no error
     */
    protected function processResult(){
        if(is_null($this->cacheFile) ||
           file_exists($this->cacheFile) == false){
            unlink($this->temp);
            if(empty($this->result[0])){
                $this->result["error"] = mb_convert_encoding($this->result["error"], "UTF-8", "SJIS");
                return false;
            }

            $this->analyzeResults =
                new Ficus_SentenceAnalyzerChasenResultAggregator();
            
            foreach($this->result as $result){
                $result = mb_convert_encoding($result, "UTF-8", "SJIS");
                $result = mb_split("\s", $result);
                if(count($result) < 4){
                    continue;
                }
                $analyzeResult =
                    new Ficus_SentenceAnalyzerChasenAnalyzeResultBean();
                $analyzeResult->setWord($result[0]);
                $analyzeResult->setReadings($result[1]);
                $analyzeResult->setRootWord($result[2]);
                $analyzeResult->setClass($result[3]);
                if(isset($result[5])){
                    $analyzeResult->setConjugationType($result[5]);
                }
                
                $this->analyzeResults->addResults($analyzeResult);
            }
            if($this->cache !== false){
                $data = serialize($this->analyzeResults->getResults());
                file_put_contents($this->cacheFile, $data);
            }
        }else{
            $data = file_get_contents($this->cacheFile);
            $data = unserialize($data);
            $this->analyzeResults = 
                new Ficus_SentenceAnalyzerChasenResultAggregator($data);
        }
        return true;
    }
}
?>
