<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2006 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.cli.ffmpeg
 */
/**
 * @file FFMpeg.php
 * @brief svn add
 * @author <a href="kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: FFMpeg.php 33 2007-08-19 18:00:31Z ishitoya $
 *
 * executes ffmpeg abstract class
 */

require_once("ficus/exception/IllegalArgumentException.php");
require_once("ficus/cli/AbstractCommandExecutor.php");
require_once("ficus/cli/ffmpeg/FFMpegConstants.php");

/**
 * @class Ficus_FFMpeg
 */
abstract class Ficus_FFMpeg extends Ficus_AbstractCommandExecutor
implements Ficus_FFMpegConstants
{
    /**
     * @var filename target filename
     */
    protected $filename = null;

    /**
     * create command
     * @return string ./ffmpeg -f build.xml
     */
    protected function createCommand(){
        if($this->isEmptyFilename()){
            throw new Ficus_NotReadyException("filename is not specified");
        }
        $command = self::FFMPEG;
        $command = $this->addOption($command, self::INPUT, '"' . $this->filename() . '"');
        return $command;
    }

    /**
     * get trimmed
     * @param $regs array input
     * @param $key string key
     * @return string trimmed string
     */
    protected final function getTrimmed($regs, $key){
        return trim($regs[$key]);
    }

    /**
     * calcurate length from string representation time
     * @param $length string like 00:00:01:0
     * @return integer calcurated length in integer
     */
    protected final function calcLength($length){
        if(preg_match('/([0-9]+):([0-9]+):([0-9]+)\.([0-9]+)/',
                      $length, $regs)){
            $hour = (integer)$this->getTrimmed($regs, 1);
            $minuite = (integer)$this->getTrimmed($regs, 2);
            $second = (integer)$this->getTrimmed($regs, 3);
            $mili = (integer)$this->getTrimmed($regs, 4);

            $time = 0;
            $time += $hour * 3600 * 1000;
            $time += $minuite * 60 * 1000;
            $time += $second * 1000;
            $time += $mili;
            return $time;
        }
        return 0;
    }

    /**
     * get size
     * @param $width integer width
     * @param $height integer height
     * @return string size string representation
     */
    protected final function getSizeString($width, $height){
        return $width . "x" . $height;
    }

    /**
     * get time string
     * @param $time integer milisecond
     * @return string 00:00:00.50
     */
    protected final function getTimeString($time){
        if($time < 0){
            return "00:00:00.0";
        }
        $hour = (integer)($time / 1000 / 3600);
        $time -= $hour * 1000 * 3600;
        $minuite = (integer)($time / 1000 / 60);
        $time -= $minuite * 1000 * 60;
        $second = (integer)($time / 1000);
        $time -= $second * 1000;
        $mili = $time;

        return sprintf("%02d:%02d:%02d.%d", $hour, $minuite, $second, $mili);
    }
}
?>
