<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.beans
 */
/**
 * @file ConcreteBean.php
 * @brief This interface is ConcreteBean.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: ConcreteBean.php 24 2007-08-01 08:33:15Z ishitoya $
 *
 */

/**
 * @class Ficus_ConcreteBean
 */
class Ficus_ConcreteBean extends Ficus_Bean{
    /**
     * constructor
     * @param $definitions of array, array of array(name, formatValue = null)
     */
    public function __construct($definitions){
        if(empty($definitions) || is_array($definitions) == false){
            throw new Ficus_IllegalArgumentException("definition must be specified");
        }
        foreach($definitions as $name => $value){
            $this->{$name} = $value;
        }
    }
}
