/*
 * $Id: ErrorReport.java,v 1.1 2006/04/23 05:15:12 sugimotokenichi Exp $
 * Copyright (C) 2004-2006 SUGIMOTO Ken-ichi
 * 쐬: 2006/04/21
 */
package feat2.testapp.test6;

import feat2.CommandContext;
import feat2.FeatError;
import feat2.FeatErrors;
import feat2.ValidationError;
import feat2.View;
import feat2.config.ViewConfig;
import feat2.template.HTMLDocument;
import feat2.template.HTMLElement;
import feat2.template.NodeFactory;

public class ErrorReport implements View {

    public HTMLDocument format(HTMLDocument template, ViewConfig cfg,
            CommandContext ctx) throws Exception {

        HTMLElement errors = template.findElement("errors");

        FeatErrors errs = ctx.getFeatErrors();

        FeatError[] errArray = errs.getErrors(ValidationError.class);
        for (int i = 0; i < errArray.length; i++) {
            errors.addText(errArray[i].getMessage());
            errors.addChild( NodeFactory.createHTMLElement("br", false) );
        }

        return template;
    }

}
