/*
 * $Id: NodeSelector.java,v 1.1 2006/04/11 16:14:32 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2005/10/29
 */
package feat2.template;

import feat2.template.impl.HTMLNodeListImpl;
import feat2.template.impl.HTMLNodeMapImpl;

/**
 * m[h郆[eBeBNXB
 * @author SUGIMOTO Ken-ichi
 */
public class NodeSelector {

    /**
     * Ce[^Ԃm[h̒ōŏɌeLXgm[hԂB
     *
     * nꂽCe[^͌m[ḧʒu܂Ői
     * (next\bhł́AŌm[h̎̃m[hԂ)B
     * m[hȂƂ́ACe[^̃\bhsÖʒuɖ߂B
     * ̃\bh̓Ce[^̃}[NύX̂ŒӁB
     * @param iterator
     * @return m[hBm[hȂƂnullԂ
     */
    public static HTMLText getText(NodeIterator iterator) {
        iterator.mark();
        while(iterator.hasNext()) {
            HTMLNode node = iterator.nextNode();
            if ( node instanceof HTMLText ) {
                return (HTMLText)node;
            }
        }
        iterator.reset();
        return null;
    }

    /**
     * Ce[^Ԃm[h̒nԖڂɌeLXgm[hԂB
     *
     * nꂽCe[^͌m[ḧʒu܂Ői
     * (next\bhł́AŌm[h̎̃m[hԂ)B
     * m[hȂƂ́ACe[^̃\bhsÖʒuɖ߂B
     * ̃\bh̓Ce[^̃}[NύX̂ŒӁB
     * @param iterator
     * @param n
     * @return m[hBm[hȂƂnullԂ
     */
    public static HTMLText getText(NodeIterator iterator, int n) {
        iterator.mark();
        int counter = 0;
        while(iterator.hasNext()) {
            HTMLNode node = iterator.nextNode();
            if ( node instanceof HTMLText ) {
                if ( ++counter == n ) {
                    return (HTMLText)node;
                }
            }
        }
        iterator.reset();
        return null;
    }

    /**
     * Ce[^Ԃm[h̒ōŌɌeLXgm[hԂB
     *
     * nꂽCe[^͍Ō̈ʒu܂ŐiނA
     * m[hȂƂ́ACe[^̃\bhsÖʒuɖ߂B
     * ̃\bh̓Ce[^̃}[NύX̂ŒӁB
     * @param iterator
     * @return m[hBm[hȂƂnullԂ
     */
    public static HTMLText getLastText(NodeIterator iterator) {
        iterator.mark();
        HTMLText ret = null;
        while(iterator.hasNext()) {
            HTMLNode node = iterator.nextNode();
            if ( node instanceof HTMLText ) {
                ret = (HTMLText)node;
            }
        }
        if ( ret == null )
            iterator.reset();
        return ret;
    }

    /**
     * Ce[^Ԃm[h̒̃eLXgm[hׂĕԂB
     *
     * nꂽCe[^͍Ō܂ŐiށB
     * @param iterator
     * @return m[h̃XgBm[hȂƂ͋̃XgԂB
     */
    public static HTMLNodeList selectTextNode(NodeIterator iterator) {
        HTMLNodeListImpl list = new HTMLNodeListImpl();
        while(iterator.hasNext()) {
            HTMLNode node = iterator.nextNode();
            if ( node instanceof HTMLText ) {
                list.add(node);
            }
        }
        return list;
    }

    /**
     * wm[hȉ̃eLXgm[h̃eLXgAԂB
     * ʂ͈̕ȉ̂悤ɐ`B<br>
     * Esƃ^u̓Xy[Xɕϊ<br>
     * EAXy[X1̃Xy[Xɒu<br>
     * E̍ŏƍŌ̃Xy[X͍폜
     * @param node JnTuc[̒_m[h
     * @return
     */
    public static String joinText(HTMLNode node) {
        int spaceCount = 0;
        HTMLNodeList list = selectTextNode(new NodeTreeIterator(node));
        int size = list.size();
        StringBuffer buf = new StringBuffer();
        for(int i=0; i<size; i++) {
            spaceCount = joinText(buf, (HTMLText)list.get(i), spaceCount, i == 0);
        }
        return buf.toString();
    }

    private static int joinText(StringBuffer buf, HTMLText textNode, int spaceCount, boolean first) {
        String text = textNode.getText();
        if ( text != null ) {
            char[] c = text.toCharArray();
            int mode = 0;
            for(int i=0; i<c.length; ) {
                switch(mode) {
                    // ʏ̕
                    case 0:
                        if ( c[i] == '\n' || c[i] == '\r' || c[i] == '\t' || c[i] == ' ' ) {
                            mode = 1;
                        }
                        else if ( c[i] == '&' ) {
                            mode = 2;
                        }
                        else {
                            if ( spaceCount > 0 && !first ) {
                                buf.append(' ');
                            }
                            spaceCount = 0;
                            first = false;
                            buf.append(c[i]);
                            i++;
                        }
                        break;
                    // Xy[X
                    case 1:
                        if ( c[i] == '\n' || c[i] == '\r' || c[i] == '\t' || c[i] == ' ' ) {
                            spaceCount++;
                            i++;
                        }
                        else {
                            mode = 0;
                        }
                        break;
                    // &nbsp
                    case 2:
                        if ( c.length - i >= 6 ) {
                            String nbsp = new String(c, i, 6);
                            if ( nbsp.equals("&nbsp") ) {
                                spaceCount++;
                                i += 6;
                            }
                            else {
                                buf.append(c[i]);
                                i++;
                            }
                        }
                        else {
                            buf.append(c[i]);
                            i++;
                        }
                        mode = 0;
                        break;
                }
            }
        }
        return spaceCount;
    }

    /**
     * Ce[^Ԃm[h̒ōŏɌw̖O̗vfԂB
     *
     * nꂽCe[^͌m[ḧʒu܂Ői
     * (next\bhł́AŌm[h̎̃m[hԂ)B
     * m[hȂƂ́ACe[^̃\bhsÖʒuɖ߂B
     * ̃\bh̓Ce[^̃}[NύX̂ŒӁB
     * @param iterator
     * @param tagName vf̖OB"*"w肷ƂׂĂ̗vfɃqbgB
     * @return m[hBm[hȂƂnullԂ
     */
    public static HTMLElement getTag(NodeIterator iterator, String tagName) {
        iterator.mark();
        while(iterator.hasNext()) {
            HTMLNode node = iterator.nextNode();
            if ( node instanceof HTMLElement ) {
                HTMLElement element = (HTMLElement)node;
                String name = element.getTagName();
                if ( tagName.equals("*") || (name != null && name.equalsIgnoreCase(tagName)) ) {
                    return element;
                }
            }
        }
        iterator.reset();
        return null;
    }

    /**
     * Ce[^Ԃm[h̒nԖڂɌw̖O̗vfԂB
     *
     * nꂽCe[^͌m[ḧʒu܂Ői
     * (next\bhł́AŌm[h̎̃m[hԂ)B
     * m[hȂƂ́ACe[^̃\bhsÖʒuɖ߂B
     * ̃\bh̓Ce[^̃}[NύX̂ŒӁB
     * @param iterator
     * @param tagName vf̖OB"*"w肷ƂׂĂ̗vfɃqbgB
     * @param n
     * @return m[hBm[hȂƂnullԂ
     */
    public static HTMLElement getTag(NodeIterator iterator, String tagName, int n) {
        iterator.mark();
        int counter = 0;
        while(iterator.hasNext()) {
            HTMLNode node = iterator.nextNode();
            if ( node instanceof HTMLElement ) {
                HTMLElement element = (HTMLElement)node;
                if ( tagName.equals("*") || element.getTagName().equalsIgnoreCase(tagName) ) {
                    if ( ++counter == n ) {
                        return element;
                    }
                }
            }
        }
        iterator.reset();
        return null;
    }

    /**
     * Ce[^Ԃm[h̒ōŌɌw̖O̗vfԂB
     *
     * nꂽCe[^͍Ō̈ʒu܂ŐiނA
     * m[hȂƂ́ACe[^̃\bhsÖʒuɖ߂B
     * ̃\bh̓Ce[^̃}[NύX̂ŒӁB
     * @param iterator
     * @param tagName vf̖OB"*"w肷ƂׂĂ̗vfɃqbgB
     * @return m[hBm[hȂƂnullԂ
     */
    public static HTMLElement getLastTag(NodeIterator iterator, String tagName) {
        iterator.mark();
        HTMLElement ret = null;
        while(iterator.hasNext()) {
            HTMLNode node = iterator.nextNode();
            if ( node instanceof HTMLElement ) {
                HTMLElement element = (HTMLElement)node;
                String name = element.getTagName();
                if ( tagName.equals("*") || (name != null && name.equalsIgnoreCase(tagName)) ) {
                    ret = element;
                }
            }
        }
        if ( ret == null )
            iterator.reset();
        return ret;
    }

    /**
     * w̃^O̗vfׂĕԂB
     * ^O͑啶/ʂȂB
     * nꂽCe[^͍Ō܂ŐiށB
     * @param iterator
     * @param tagName ^O̖OB"*"w肳ꂽƂׂ͂Ẵ^OY
     * @return ʂ̃XgBYm[hȂƂ̓TCY0̃Xg
     */
    public static HTMLNodeList selectTags(NodeIterator iterator, String tagName) {
        HTMLNodeListImpl list = new HTMLNodeListImpl();
        while(iterator.hasNext()) {
            HTMLNode node = iterator.nextNode();
            if ( node instanceof HTMLElement ) {
                HTMLElement element = (HTMLElement)node;
                String name = element.getTagName();
                if ( tagName.equals("*") || (name != null && name.equalsIgnoreCase(tagName)) ) {
                    list.add(node);
                }
            }
        }
        return list;
    }

    /**
     * Ce[^Ԃm[h̒ōŏɌw葮l̗vfԂB
     *
     * nꂽCe[^͌m[ḧʒu܂Ői
     * (next\bhł́AŌm[h̎̃m[hԂ)B
     * m[hȂƂ́ACe[^̃\bhsÖʒuɖ߂B
     * ̃\bh̓Ce[^̃}[NύX̂ŒӁB
     * @param iterator
     * @param attrName 
     * @param attrVal l
     * @return m[hBm[hȂƂnullԂ
     */
    public static HTMLElement getElementByAttribute(NodeIterator iterator, String attrName, String attrVal) {
        iterator.mark();
        while(iterator.hasNext()) {
            HTMLNode node = iterator.nextNode();
            if ( node instanceof HTMLElement ) {
                HTMLElement element = (HTMLElement)node;
                String val = element.getAttribute(attrName);
                if ( val != null && val.equals(attrVal) ) {
                    return element;
                }
            }
        }
        iterator.reset();
        return null;
    }

    /**
     * w葮l̗vfׂĕԂB
     * nꂽCe[^͍Ō܂ŐiށB
     * @param iterator
     * @param attrName 
     * @param attrVal l
     * @return ʂ̃XgBYm[hȂƂ̓TCY0̃Xg
     */
    public static HTMLNodeList selectElementsByAttribute(NodeIterator iterator, String attrName, String attrVal) {
        HTMLNodeListImpl list = new HTMLNodeListImpl();
        while(iterator.hasNext()) {
            HTMLNode node = iterator.nextNode();
            if ( node instanceof HTMLElement ) {
                HTMLElement element = (HTMLElement)node;
                String val = element.getAttribute(attrName);
                if ( val != null && val.equals(attrVal) ) {
                    list.add(node);
                }
            }
        }
        return list;
    }

    /**
     * Ce[^Ԃm[h̒ōŏɌwclass̗vfԂB
     *
     * nꂽCe[^͌m[ḧʒu܂Ői
     * (next\bhł́AŌm[h̎̃m[hԂ)B
     * m[hȂƂ́ACe[^̃\bhsÖʒuɖ߂B
     * ̃\bh̓Ce[^̃}[NύX̂ŒӁB
     * @param iterator
     * @param className class
     * @return m[hBm[hȂƂnullԂ
     */
    public static HTMLElement getElementByClass(NodeIterator iterator, String className) {
        iterator.mark();
        while(iterator.hasNext()) {
            HTMLNode node = iterator.nextNode();
            if ( node instanceof HTMLElement ) {
                HTMLElement element = (HTMLElement)node;
                if ( element.containsClassValue(className) ) {
                    return element;
                }
            }
        }
        iterator.reset();
        return null;
    }

    /**
     * w葮l̗vfׂĕԂB
     * nꂽCe[^͍Ō܂ŐiށB
     * @param iterator
     * @param className class
     * @return ʂ̃XgBYm[hȂƂ̓TCY0̃Xg
     */
    public static HTMLNodeList selectElementsByClass(NodeIterator iterator, String className) {
        HTMLNodeListImpl list = new HTMLNodeListImpl();
        while(iterator.hasNext()) {
            HTMLNode node = iterator.nextNode();
            if ( node instanceof HTMLElement ) {
                HTMLElement element = (HTMLElement)node;
                if ( element.containsClassValue(className) ) {
                    list.add(node);
                }
            }
        }
        return list;
    }

    /**
     * idvfׂđIB
     * idlm[hƂ͍ŌɌ̂ʂɊi[B
     * @return idlɃ}bsOꂽm[h̃RNV
     */
    public static HTMLNodeMap selectIdentifiableElements(NodeIterator iterator) {
        HTMLNodeMapImpl map = new HTMLNodeMapImpl();
        while(iterator.hasNext()) {
            HTMLNode node = iterator.nextNode();
            if ( node instanceof HTMLElement ) {
                HTMLElement element = (HTMLElement)node;
                if ( element.getId()!= null ) {
                    map.put(element.getId(), element);
                }
            }
        }
        return map;
    }

}
