/*
 * $Id: RedirectResponse.java,v 1.7 2006/04/24 02:20:02 sugimotokenichi Exp $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 쐬: 2006/03/17
 */
package feat2.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import feat2.CommandContext;
import feat2.FeatRuntimeException;
import feat2.FileUploadException;
import feat2.Processor;
import feat2.PropertyAccessException;
import feat2.Response;
import feat2.StringUtil;
import feat2.config.RedirectConfig;

/**
 * _CNgB
 * @author SUGIMOTO Ken-ichi
 */
public class RedirectResponse implements Response {

    private RedirectConfig config;


    public RedirectResponse(RedirectConfig config) {
        this.config = config;
    }


    public String output(CommandContext ctx)
            throws IOException, PropertyAccessException, FileUploadException {

        // ͒l

        Map inputs = Processor.processInputs(config, null, ctx);

        String encoding = ctx.getCurrentFeatureConfig().getEncoding();
        if ( encoding == null )
            encoding = "UTF-8";

        // _CNg

        if ( config.getMethod().equalsIgnoreCase("get") ) {

            // GET\bhŃ_CNgꍇ

            String uri = config.getUri();
            String query = null;

            if ( uri.indexOf('#') > -1 )
                uri = uri.substring(0, uri.indexOf('#'));

            if ( uri.indexOf('?') > -1 ) {
                query = uri.substring(uri.indexOf('?')+1);
                uri = uri.substring(0, uri.indexOf('?'));
            }

            // NG[č\z

            String[] pairs = StringUtil.split(query, '&');
            HashMap queryMap = new HashMap();

            if ( pairs != null ) {

                // NG[}bvɓ

                for (int i = 0; i < pairs.length; i++) {

                    if ( pairs[i].indexOf('=') > -1 ) {
                        String[] pair = StringUtil.split(pairs[i], '=');
                        queryMap.put(pair[0], pair[1]);
                    }
                    else{
                        queryMap.put(pairs[i], "");
                    }

                }

            }

            // ͒l}bvɒǉ

            for (Iterator keys = inputs.keySet().iterator(); keys.hasNext();) {
                String key = (String)keys.next();
                String value = (String)inputs.get(key);
                queryMap.put(URLEncoder.encode(key, encoding), URLEncoder.encode(value, encoding));
            }
            //queryMap.putAll(inputs);

            // }bvNG[ɕϊ

            StringBuffer queryBuf = new StringBuffer();
            for(Iterator it=queryMap.keySet().iterator(); it.hasNext(); ) {

                String key = (String)it.next();
                String val = (String)queryMap.get(key);

                if ( query != null && query.length() > 0 ) {
                    queryBuf.append('&');
                }

                queryBuf.append(key);

                if ( val != null && val.length() > 0 ) {
                    queryBuf.append('=');
                    queryBuf.append(val);
                }

            }

            // _CNg

            String newUri = uri;
            if ( queryBuf.length() > 0 )
                newUri = newUri + "?" + queryBuf.toString();
            ctx.getResponse().sendRedirect(newUri);


        }

        else if ( config.getMethod().equalsIgnoreCase("post") ) {

            // POST\bhŃ_CNgꍇ

            StringBuffer html = new StringBuffer();
            StringBuffer form = new StringBuffer();

            html.append("<html><head>");
            html.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=");
            html.append(encoding);
            html.append("\">\n");
            html.append("<script type=\"text/javascript\">\n<!--\n");
            html.append("function submitForm() {\n");

            form.append("<form name=\"form0\" method=\"post\" action=\"");
            form.append(config.getUri());
            form.append("\">\n");

            for(Iterator it=inputs.keySet().iterator(); it.hasNext(); ) {

                // tH[ɒlZbgJavaScript

                String key = (String)it.next();
                String val = (String)inputs.get(key);

                html.append("    document.forms[0]");
                html.append(".elements[\"").append(key).append("\"].value");
                html.append(" = \"");
                html.append(StringUtil.escapeJavaScriptString(val));
                html.append("\";\n");

                // tH[̗vf

                form.append("<input type=\"hidden\" name=\"").append(key);
                form.append("\">\n");

            }

            // tH[submitJavaScript

            html.append("    document.forms[0].submit();\n");
            html.append("}\n//-->\n</script></head>\n");

            form.append("</form>\n");

            // bodyvf

            html.append("<body onLoad=\"submitForm();\">");
            html.append(form);
            //html.append("<script type=\"text/javascript\">\nsubmitForm();\n</script>");

            html.append("</body></html>");

            // o

            OutputStream out = ctx.getResponse().getOutputStream();
            out.write(html.toString().getBytes(encoding)); // FIXME configŏo̓GR[fBOwł悤ɂBwȂ̂Ƃ̓tB[`[Őݒ肳ꂽGR[fBO
            out.flush();
            out.close();

        }

        else {

            // ݒt@C̃of[VŌĂ̂łւ͗Ȃ͂

            throw new FeatRuntimeException("");
        }

        return null;

    }

}
