/*
 * $Id: ValidationSupport.java,v 1.3 2006/04/21 15:04:21 sugimotokenichi Exp $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 쐬: 2006/03/08
 */
package feat2.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import feat2.FeatErrors;
import feat2.config.type.Identifier;

/**
 * ValidationvfT|[g邽߂̃NXB
 * FIXME ActionconfigBasěp͕KvH
 * @author SUGIMOTO Ken-ichi
 */
public class ValidationSupport /*extends ActionConfigBase*/ implements
        ValidatableComponentConfig {

    private Config parent;
    private ArrayList validations;
    private boolean sorted;

    public ValidationSupport(Config parent) {
        this.parent = parent;

        validations = new ArrayList();
        sorted = false;
    }

    public void addValidation(ValidationConfig validation) {
        validations.add(validation);
        validation.setParent(parent);
        sorted = false;
    }

    public ValidationConfig[] getValidations() throws ConfigurationException {
        if ( !sorted ) {
            validations = sortValidation(validations);
            sorted = true;
        }
        return (ValidationConfig[])validations.toArray(new ValidationConfig[0]);
    }

    public ValidationConfig getValidationConfig(String name) {
        for (Iterator iter = validations.iterator(); iter.hasNext();) {
            ValidationConfig cfg = (ValidationConfig) iter.next();
            if ( cfg.getName().getValue().equals(name) )
                return cfg;
        }
        return null;
    }

    /**
     * o^Ăof[VݒIuWFNg̐ԂB
     */
    public int count() {
        return validations.size();
    }

    public boolean validate(FeatErrors errs) {
        return ConfigUtil.validate(validations.iterator(), errs);
    }


    /**
     * ؂̐ݒˑ֌W̏Ƀ\[gB
     * @param validations
     * @return
     * @throws ConfigurationException of[V̈ˑ֌WɏzQƂƂ
     */
    private ArrayList sortValidation(List validations) throws ConfigurationException {
        ArrayList ret = new ArrayList();
        Dependencies dep = new Dependencies();

        // ˑ֌W

        for(int i=0; i<validations.size(); i++) {

            ValidationConfig config = (ValidationConfig)validations.get(i);
            dep.addDependency(config, null);

            // ˑׂĈˑ֌Wɒǉ

            ValidationConfig[] depends = config.getDepends();
            for(int ii=0; ii<depends.length; ii++) {

                dep.addDependency(config, depends[ii]);

            }

        }

        // š

        while( dep.count() > 0 ) {

            Object o = dep.getIndependentObject();
            if ( o == null ) {

                // ׂẴIuWFNgǂɈˑĂ̂ŁAzQ
                throw new ConfigurationException("error.config.ValidationConfig.recurrence");

            }

            dep.removeDependencies(o);
            ret.add(o);
        }

        return ret;
    }

    /**
     * ̃\bh͂̃NXł̓T|[gȂB
     * @return nullԂB
     */
    public String getPropertyNameId(String propertyName) {
        return null;
    }

    /**
     * ̃\bh͂̃NXł̓T|[gȂB
     * @return nullԂB
     */
    public Identifier getErrorResponse() {
        return null;
    }

}
