/*
 * $Id: InputSupport.java,v 1.1 2006/04/11 16:14:32 sugimotokenichi Exp $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 쐬: 2006/03/08
 */
package feat2.config;

import java.util.ArrayList;

import feat2.FeatErrors;

/**
 * InputvfT|[g邽߂̃NXB
 * @author SUGIMOTO Ken-ichi
 */
public class InputSupport implements DIComponentConfig {

    private ArrayList inputs;
    private Config config;

    public InputSupport(Config config) {
        this.config = config;
        inputs = new ArrayList();
    }

    public void addInput(InputConfigBase input) {
        inputs.add(input);
        input.setParent(config);
    }

    public InputConfigBase[] getInputs() {
        return (InputConfigBase[])inputs.toArray(new InputConfigBase[inputs.size()]);
    }

    public InputConfigBase getInputConfig(String propertyName) {
        InputConfigBase ret = (InputConfigBase)ConfigUtil.getConfig(inputs, propertyName);
        return ret;
    }

    // TODO ̃\bhg悤ɕύX
    public boolean validate(FeatErrors errs) {
        return ConfigUtil.validate(inputs.iterator(), errs);
    }

}
