/*
 * $Id: FeatException.java,v 1.2 2006/04/12 10:47:20 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 */

package feat2;

import java.util.HashMap;

public class FeatException extends Exception {

    // TODO level͔p~BȌd傳̓NXŋʂ

    /** [UZbVAEFuAvP[V𑱍słG[ */
    public static final int LEVEL_WARN = 1;
    /** [UZbV𑱍słȂA܂̓X|XԂƂłȂ炢̃G[ */
    public static final int LEVEL_ERROR = 2;
    /** EFuAvP[V𑱍słȂ炢̃G[ */
    public static final int LEVEL_FATAL = 3;

    private int level;

    public FeatException(Throwable cause, int level) {
        super(cause);
        this.level = level;
    }

    public FeatException(String message, int level) {
        super(message);
        this.level = level;
    }

    public FeatException(String message, Throwable cause, int level) {
        super(message, cause);
        this.level = level;
    }

    /*public FeatException() {
        super();
        this.level = LEVEL_ERROR;
    }*/

    /*public FeatException(Throwable cause) {
        super(cause);
        this.level = LEVEL_ERROR;
    }

    public FeatException(String message) {
        super(message);
        this.level = LEVEL_ERROR;
    }

    public FeatException(String message, Throwable cause) {
        super(message, cause);
        this.level = LEVEL_ERROR;
    }*/

    public int getLevel() {
        return level;
    }









    private static final long serialVersionUID = "$Id: FeatException.java,v 1.2 2006/04/12 10:47:20 sugimotokenichi Exp $".hashCode();

    private String messageId;
    private HashMap keywords;


    public FeatException() {
        super();
        keywords = new HashMap();
    }

    public FeatException(String messageId, Throwable cause) {
        super(cause);
        this.messageId = messageId;
        keywords = new HashMap();
    }

    public FeatException(String messageId) {
        super();
        this.messageId = messageId;
        keywords = new HashMap();
    }

    public FeatException(Throwable cause) {
        super(cause);
        keywords = new HashMap();
    }


    public String getMessageId() {
        return messageId;
    }


    /**
     * bZ[W̃L[[huǉB
     * @param key
     * @param word
     */
    public void addKeyword(String key, String word) {
        keywords.put(key, word);
    }


    /**
     * bZ[WIDɑΉG[bZ[WԂB
     * \[X}l[W̓ftHgFileResourceManagergB
     * \[XȂƂ̓\[XIDԂB
     */
    public String getMessage() {

        String message = FileResourceManager.getInstance().getStringResource(messageId);

        if ( message == null )
            return messageId;

        message = StringUtil.replaceParameters(message, keywords);
        return message;

    }


}
